/*
 * This file/code is part of Paper UI project.
 *
 * Paper UI - is a modern front-end framework based on Material Design by Google
 * https://github.com/virtyaluk/paper-ui
 *
 * Copyright (c) 2015 Bohdan Shtepan
 * http://modern-dev.com/
 *
 * Licensed under the MIT license.
 */
 !function(t,e,i){"use strict";function n(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}var s=function(){function t(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(e,i,n){return i&&t(e.prototype,i),n&&t(e,n),e}}(),o=function(){function t(e){return n(this,t),this._element=e,this.width=this.boundingRect.width,this.height=this.boundingRect.height,this.size=Math.max(this.width,this.height),this}return s(t,[{key:"distanceToFarthestCorner",value:function(e){var i=e.x,n=void 0===i?0:i,s=e.y,o=void 0===s?0:s;return Math.max(t.euclideanDistance({x:n,y:o},{x:0,y:0}),t.euclideanDistance({x:n,y:o},{x:this.width,y:0}),t.euclideanDistance({x:n,y:o},{x:0,y:this.height}),t.euclideanDistance({x:n,y:o},{x:this.width,y:this.height}))}},{key:"contains",value:function(t){var e=t.x,i=t.y,n=t.clientX,s=t.clientY,o=this.boundingRect.left,r=this.boundingRect.top,a=this.boundingRect.width,h=this.boundingRect.height,c=e||n||0,u=i||s||0;return c>=o&&o+a>=c&&u>=r&&r+h>=u}},{key:"center",get:function(){return{x:this.width/2,y:this.height/2}}},{key:"boundingRect",get:function(){return this._element.getBoundingClientRect()}}],[{key:"euclideanDistance",value:function(t,e){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))}}]),t}(),r=t||void 0,a=r.document,h=function(){return r.performance&&r.performance.now?r.performance.now.bind(r.performance):Date.now}(),c=function(){function t(e){var i=e.$,s=e.recenters,h=void 0===s?!1:s,c=e.center,u=void 0===c?!1:c,d=e.initialOpacity,l=void 0===d?.25:d,p=e.opacityDecayVelocity,y=void 0===p?.8:p;return n(this,t),this.color=r.getComputedStyle(i).color,this.containerRect=new o(i),this.recenters=h,this.center=u,this.initialOpacity=l,this.opacityDecayVelocity=y,this.$wave=a.createElement("div"),this.$wave.classList.add("paper-ripple__wave"),this.$wave.style.backgroundColor=this.color,this.$=a.createElement("div"),this.$.classList.add("paper-ripple__wave-container"),this.$.appendChild(this.$wave),this.resetDefaults(),this}return s(t,[{key:"resetDefaults",value:function(){return this.maxRadius=0,this.touchDownStarted=0,this.touchUpStarted=0,this.startPosition={x:0,y:0},this.endPosition={x:0,y:0},this}},{key:"draw",value:function(){var t=void 0,e=this.radius/(this.containerRect.size/2),i=this.containerRect.center,n=this.currentPosition,s={x:n.x-i.x,y:n.y-i.y};return this.$wave.style.opacity=this.opacity,t="translate("+s.x+"px, "+s.y+"px)",this.$.style.webkitTransform=t,this.$.style.mozTransform=t,this.$.style.msTransform=t,this.$.style.oTransform=t,this.$.style.transform="translate3d("+s.x+"px, "+s.y+"px, 0)",t="scale("+e+","+e+")",this.$wave.style.webkitTransform=t,this.$wave.style.mozTransform=t,this.$wave.style.msTransform=t,this.$wave.style.oTransform=t,this.$wave.style.transform="scale3d("+e+","+e+", 1)",this}},{key:"downAction",value:function(){var t=arguments.length<=0||void 0===arguments[0]?null:arguments[0],e=this.containerRect.center;return this.resetDefaults(),this.touchDownStarted=h(),this.startPosition=this.center||!t?e:{x:(t.clientX||t.x)-this.containerRect.boundingRect.left,y:(t.clientY||t.y)-this.containerRect.boundingRect.top},this.endPosition=this.recenters?e:this.endPosition,this.maxRadius=this.containerRect.distanceToFarthestCorner(this.startPosition),this.$.style.top=(this.containerRect.height-this.containerRect.size)/2+"px",this.$.style.left=(this.containerRect.width-this.containerRect.size)/2+"px",this.$.style.width=this.containerRect.size+"px",this.$.style.height=this.containerRect.size+"px",this}},{key:"upAction",value:function(){return this.isTouchDown?(this.touchUpStarted=h(),this):this}},{key:"remove",value:function(){return this.$.parentNode.removeChild(this.$),this}},{key:"touchDownElapsed",get:function(){var t;return this.touchDownStarted?(t=h()-this.touchDownStarted,this.touchUpStarted&&(t-=this.touchUpElapsed),t):0}},{key:"touchUpElapsed",get:function(){return this.touchUpStarted?h()-this.touchUpStarted:0}},{key:"touchDownElapsedSeconds",get:function(){return this.touchDownElapsed/1e3}},{key:"touchUpElapsedSeconds",get:function(){return this.touchUpElapsed/1e3}},{key:"mouseInteractionSeconds",get:function(){return this.touchDownElapsedSeconds+this.touchUpElapsedSeconds}},{key:"radius",get:function(){var e=1.1*Math.min(Math.sqrt(Math.pow(this.containerRect.width,2)+Math.pow(this.containerRect.height,2)),t.MAX_RADIUS)+5,i=1.1-.2*(e/t.MAX_RADIUS),n=this.mouseInteractionSeconds/i,s=e*(1-Math.pow(80,-n));return Math.abs(s)}},{key:"opacity",get:function(){return this.touchUpStarted?Math.max(0,this.initialOpacity-this.touchUpElapsedSeconds*this.opacityDecayVelocity):this.initialOpacity}},{key:"outerOpacity",get:function(){return Math.max(0,Math.min(.3*this.touchUpElapsedSeconds,this.opacity))}},{key:"isWaveFullyOpaque",get:function(){return this.opacity<.01&&this.radius>=Math.min(this.maxRadius,t.MAX_RADIUS)}},{key:"isMaxRadiusReached",get:function(){return this.opacity>=this.initialOpacity&&this.radius>=Math.min(this.maxRadius,t.MAX_RADIUS)}},{key:"isAnimationComplete",get:function(){return this.touchUpStarted?this.isWaveFullyOpaque:this.isMaxRadiusReached}},{key:"translationFraction",get:function(){return Math.min(1,this.radius/this.containerRect.size*2/Math.sqrt(2))}},{key:"currentPosition",get:function(){var t=this.translationFraction,e=this.startPosition.x,i=this.startPosition.y;return this.endPosition.x&&(e=this.startPosition.x+t*(this.endPosition.x-this.startPosition.x)),this.endPosition.y&&(i=this.startPosition.y+t*(this.endPosition.y-this.startPosition.y)),{x:e,y:i}}},{key:"isTouchDown",get:function(){return this.touchDownStarted&&!this.touchUpStarted}}]),t}();c.MAX_RADIUS=300;var u=function(){function e(t){n(this,e);var i=t||{},s=i.initialOpacity,o=void 0===s?.25:s,r=i.opacityDecayVelocity,a=void 0===r?.8:r,h=i.recenters,c=void 0===h?!1:h,u=i.center,d=void 0===u?!1:u,l=i.round,p=void 0===l?!1:l,y=i.target,v=void 0===y?null:y;return this.initialOpacity=o,this.opacityDecayVelocity=a,this._waves=[],this._initTarget(t&&t.nodeType?t:v&&v.nodeType?v:null),this.recenters=c||this.recenters,this.center=d||this.center,this.round=p||this.round,this}return s(e,[{key:"_initTarget",value:function(){var e=arguments.length<=0||void 0===arguments[0]?null:arguments[0],i=i||t.document;return this.$||(this.$=e||i.createElement("div"),this.$.classList.add("paper-ripple")),this.$background||(this.$background=e&&e.querySelector(".paper-ripple__background")||i.createElement("div"),this.$background.classList.add("paper-ripple__background"),this.$.appendChild(this.$background)),this.$waves||(this.$waves=e&&e.querySelector(".paper-ripple__waves")||i.createElement("div"),this.$waves.classList.add("paper-ripple__waves"),this.$.appendChild(this.$waves)),this}},{key:"addWave",value:function(){var t=new c(this);return this.$waves.appendChild(t.$),this.$background.style.backgroundColor=t.color,this._waves.push(t),t}},{key:"downAction",value:function(t){var e=this.addWave();return e.downAction(t),this.animate(),this}},{key:"upAction",value:function(){return this._waves.forEach(function(t){t.upAction()}),this.animate(),this}},{key:"removeWave",value:function(t){var e=this._waves.indexOf(t);return 0>e?this:(this._waves.splice(e,1),t.remove(),this)}},{key:"animate",value:function(){var e=void 0,i=void 0,n=void 0;for(e=0,i=this._waves.length;i>e;e++)n=this._waves[e],n&&(n.draw(),this.$background.style.opacity=n.outerOpacity,n.isWaveFullyOpaque&&!n.isMaxRadiusReached&&this.removeWave(n));return this.shouldKeepAnimating||0!==this._waves.length?t.requestAnimationFrame(this.animate.bind(this)):this.$background.style.backgroundColor=null,this}},{key:"recenters",get:function(){return this.$.hasAttribute("recenters")},set:function(t){this.$[t?"setAttribute":"removeAttribute"]("recenters","")}},{key:"center",get:function(){return this.$.hasAttribute("center")},set:function(t){this.$[t?"setAttribute":"removeAttribute"]("center","")}},{key:"round",get:function(){return this.$.classList.contains("paper-ripple--round")},set:function(t){this.$.classList.toggle("paper-ripple--round",t)}},{key:"shouldKeepAnimating",get:function(){return this._waves.some(function(t){return!t.isAnimationComplete})}}]),e}();i.exports=u;var d=function(){return t.navigator.msPointerEnabled?t.PointerEvent?{down:"pointerdown",up:"pointerup"}:{down:"MSPointerDown",up:"MSPointerUp"}:{down:"touchstart",up:"touchend"}}();e.fn.paperRipple=function(t){return this.each(function(){var i=new u(t),n={};n["mousedown "+d.down]=function(t){i.downAction(t)},n["mouseup "+d.up]=function(){i.upAction()},e(this).prepand(i.$).on(n)})}}(window,jQuery,{});
