<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4 charge-page">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="text-center caption">
                    <h1><?= ($active_charge_page) ? 'شارژ کیف پول' : 'موجودی کیف پول' ?></h1>
                </div>

                <div class="row">
                    <div class="col-md-6 m-auto pay-box <?= ($active_charge_page) ? 'm-b-20' : 'm-b-100' ?>">
                        <?php if ($this->session->flashdata('frontend_error')): ?>
                            <div class="alert alert-danger text-center">
                                <?= $this->session->flashdata('frontend_error') ?>
                            </div>
                        <?php endif; ?>
                        <div class="shadow half-box p-15">
                            <div class="row">
                                <div class="col-12 text-center">
                                    <span>موجودی:</span>
                                    <span class="bold user-credit"><?= number_format($user_login->credit) ?></span>
                                    <span>تومان</span>
                                </div>
                                <?php if($active_charge_page): ?>
                                    <form id="main-form" action="<?= base_url('pay/request') ?>" method="post" enctype="multipart/form-data">
                                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                                        <?php if($settings->show_gift_box): ?>
                                            <nav>
                                                <div class="nav nav-tabs text-center nav-pay" id="nav-tab" role="tablist">
                                                    <button class="nav-link active" id="nav-direct-tab" data-bs-toggle="tab" data-bs-target="#nav-direct" type="button" role="tab" aria-controls="nav-direct" aria-selected="true">پرداخت</button>
                                                    <button class="nav-link" id="nav-gift-tab" data-bs-toggle="tab" data-bs-target="#nav-gift" type="button" role="tab" aria-controls="nav-gift" aria-selected="false">کارت هدیه</button>
                                                </div>
                                            </nav>
                                        <?php endif; ?>
                                        <div class="tab-content" id="nav-tabContent">
                                            <div class="tab-pane fade show active" id="nav-direct" role="tabpanel" aria-labelledby="nav-direct-tab" tabindex="0">
                                                <div class="col-12 col-lg-8 col-md-12 col-sm-8 m-auto m-t-20">
                                                    <div class="form-group">
                                                        <div class="input-group">
                                                            <span class="input-group-addon">
                                                                مبلغ(تومان)
                                                            </span>
                                                            <input type="text" id="txt-price" name="price" class="form-control ltr text-center separate numeric" required title="مبلغ" placeholder="مبلغ دلخواه شما">
                                                        </div><!-- /.input-group -->
                                                        <div class="help-block"></div>
                                                    </div><!-- /.form-group -->
                                                </div><!-- /.col -->
                                                <?php if($packages): ?>
                                                    <div class="col-12 charge-packages">
                                                        <?php foreach ($packages as $item): ?>
                                                            <span class="charge-package" data-value="<?= $item ?>"><?= number_format($item) ?></span>
                                                        <?php endforeach; ?>
                                                    </div>
                                                <?php endif; ?>

                                                <div id="pure-dollar-total" class="row <?= intval($settings->rate->dollar) > 0 ? '' : 'd-none' ?> <?= in_array($default_gateway, $dollar_gateways) ? '' : 'hide'?>">
                                                    <div class="col-12 col-lg-8 col-md-12 col-sm-8 m-auto gx-3">
                                                        <div class="row has-style">
                                                            <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                                                                <span class="title-box">معادل:</span>
                                                            </div>
                                                            <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                                                                <label class="box">
                                                                    <span class="amount"></span>
                                                                    <span class="currency pe-1"> دلار</span>
                                                                </label>
                                                            </div>
                                                        </div><!-- /.row -->
                                                    </div><!-- /.col -->
                                                </div><!-- /.row -->
    
                                                <div class="col-12 m-t-20">
                                                    <?= $html_gateways ?>
                                                </div><!-- /.row -->
                                                <div class="col-12 text-center m-t-30">
                                                    <button type="button" class="btn bg-gradient-primary font-md m-t-0" id="btn-save">
                                                        <i class="fa fa-credit-card"></i> پرداخت
                                                    </button>
                                                </div><!-- /.col -->
                                            </div>
                                            <div class="tab-pane fade" id="nav-gift" role="tabpanel" aria-labelledby="nav-gift-tab" tabindex="0">
                                                <?php if($settings->show_gift_box): ?>
                                                    <div class="col-12 m-t-20">
                                                        <div class="form-group">
                                                            <!-- <label>کارت هدیه <span class="small">(اگر کد دارید وارد کنید)</span></label> -->
                                                            <div class="input-group">
                                                                <input type="text" class="form-control ltr text-left" id="txt-gift" name="gift" placeholder="در صورتی که کارت هدیه دارید وارد کنید" title="کارت هدیه" autocomplete="off">
                                                                <span class="input-group-btn">
                                                                    <button class="btn bg-gradient-primary" id="save-gift" type="button">
                                                                        <span class="loading hide"><i class="fa fa-spinner fa-spin"></i></span>
                                                                        ثبت
                                                                    </button>
                                                                </span>
                                                            </div>
                                                            <div class="help-block"></div>
                                                            <div class="alert hide" id="alert-result-gift"></div>
                                                        </div><!-- /.form-group -->
                                                    </div><!-- /.col -->
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </form>
                                <?php endif; ?>
                            </div><!-- /.row -->
                        </div>
                    </div>
                </div>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.main -->

<script>
    maxQty = 0;
</script>