<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
    <head>
        <title><?=$meta_title?></title>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="index,follow">
        <meta name="description" content="<?=$meta_description?>">
        <meta name="keywords" content="<?=$meta_keywords?>">
        <meta name="fontiran.com:license" content="LGQO6EA0">
        
        <meta property="og:title" content="<?=$meta_title?>">
        <meta property="og:site_name" content="<?=$settings->site_name?>">
        <meta property="og:description" content="<?=$meta_description?>">
        <meta property="og:image" content="<?=$meta_image?>">

        <link rel="icon" type="image/png" href="<?= base_url($settings->favicon) ?>">

        <!-- CSS -->
        <link href="<?= base_url() ?>assets/plugins/material/material-kit.css?<?= ($settings->version) ?>" rel="stylesheet">
        <link href="<?= base_url() ?>assets/plugins/font-awesome/css/font-awesome.min.css?<?= ($settings->version) ?>" rel="stylesheet">
        <link href="<?= base_url() ?>assets/plugins/owl/owl.carousel.min.css?<?= ($settings->version) ?>" rel="stylesheet">

        <!-- Page CSS -->
        <?php if (isset($css) && count($css)): ?>
            <?php foreach ($css as $url): ?>
                <link href="<?=base_url($url) . "?" . $settings->version ?>?>" rel="stylesheet">
            <?php endforeach ?>
        <?php endif ?>

        <!-- Main CSS -->
        <link href="<?= base_url() ?>assets/css/style.css?<?= ($settings->version) ?>" rel="stylesheet">
        <link href="<?= base_url() ?>assets/css/colors.css?<?= ($settings->version) ?>" rel="stylesheet">
        <?php if(isset($settings->font->public) && $settings->font->public): ?>
            <link href="<?= base_url() ?>assets/css/<?= $settings->font->public ?>.css?<?= ($settings->version) ?>" rel="stylesheet">
        <?php endif ?>

        <!-- Canonical -->
        <?php if(isset($canonical) && $canonical): ?>
            <link rel="canonical" href="<?= $canonical ?>">
        <?php endif ?>

        <!-- Java Script -->
        <script type="text/javascript" language="javascript" src="<?= base_url() ?>assets/plugins/jquery/dist/jquery-3.6.1.min.js?<?= ($settings->version) ?>"></script>
        <script>
            // let selectedCategoryId = 0;
            var baseUrl = '<?php echo base_url() ?>';
            var csrfToken = '<?php echo $this->security->get_csrf_token_name(); ?>';
            var dollarRate = <?= $this->settings->rate->dollar ? $this->settings->rate->dollar : 0?>;
        </script>
        
        <?= ($settings->header_script) ? $settings->header_script : '' ?>

        
    </head>
