<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-user"></i>
                    مدیران
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col col-md-12">
                    <?php if (in_array('users_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/users/edit') ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('users_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/users/block'); ?>', '#frm-main', '<?php echo base_url('/admin/users/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="بلاک کردن">
                            <i class="icon-lock"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/users/unblock'); ?>', '#frm-main', '<?php echo base_url('/admin/users/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="بازیابی">
                            <i class="icon-lock-open"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('users_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?php echo base_url('admin/users/delete'); ?>', '#frm-main', '<?php echo base_url('/admin/users/view'); ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- col -->
            </div><!-- row -->
            <div>
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids"/>
                </form>
            </div>
            <br>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="data-table">
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th>نام</th>
                            <th>نام خانوادگی</th>
                            <th>نام کاربری</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($users): ?>
                            <?php foreach ($users as $key => $user): ?>
                                <tr>
                                    <td>
                                        <?php if($user_login->id != $user->id): ?>
                                            <input type="checkbox" value="<?= $user->id ?>">
                                        <?php endif; ?>
                                    </td>
                                    <td><?= $key+1  ?></td>
                                    <td><?= $user->first_name ?></td>
                                    <td><?= $user->last_name ?></td>
                                    <td><?= $user->username ?></td>
                                    <td>
                                        <?php if (in_array('users_edit', $user_permissions)) : ?>
                                            <a class="btn btn-warning  btn-round btn-icon has-tooltip" title="ویرایش" href="<?= base_url('admin/users/edit/' . $user->id) ?>" ><i class="icon-pencil"></i></a>
                                            <a class="btn btn-primary  btn-round btn-icon has-tooltip" title="تغییر رمز عبور" href="<?= base_url('admin/users/changePasswordEdit/' . $user->id) ?>" ><i class="icon-key"></i></a>
                                        <?php endif; ?>
                                        
                                        <?php if($user_login->id != $user->id): ?>
                                            <?php if (in_array('users_edit', $user_permissions)) : ?>
                                                <?php if ($user->block == 0): ?>
                                                    <a class="btn btn-success btn-round btn-icon has-tooltip" title="بلاک کردن" href="javascript: void(0)" onclick="insert('<?= base_url("admin/users/block/" . $user->id) ?>', '#frm-main', '<?= base_url("admin/users/view") ?>', '#res', '#msg', false, true, 'noty')" ><i class="icon-lock"></i></a>
                                                <?php else :?>
                                                    <a class="btn btn-danger btn-round btn-icon has-tooltip" title="بازیابی" href="javascript: void(0)" onclick="insert('<?php echo base_url('/admin/users/unblock/') . $user->id; ?>', '#frm-main', '<?php echo base_url('/admin/users/view'); ?>', '#res', '#msg', false, true, 'noty')"><i class="icon-lock-open"></i></a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if (in_array('users_delete', $user_permissions)) : ?>
                                                <a class="btn btn-danger  btn-round btn-icon has-tooltip" title="حذف" href="javascript: void(0)" onclick="deleteRow('<?php echo base_url('/admin/users/delete/') . $user->id; ?>', '#frm-main', '<?php echo base_url('/admin/users/view'); ?>', '#res', 'delete');"><i class="icon-trash"></i></a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php endif ?>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function () {
        var selectedMain = [];
        var tableMain = $('#data-table').DataTable({
            "pageLength": 25,
            "rowCallback": function(row, data) {
                //window.Modiran.initiCkeck();
            },
            "drawCallback": function( settings ) {
                chackAllStatus($('#data-table'));
            },
            "sPaginationType": "full_numbers",
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false, "class": "width-10"},
                {"data": "first_name"},
                {"data": "last_name"},
                {"data": "username"},
                {"data": "actions", "orderable": false}
            ],
            "order": []
        });

             // Select checkboxes
        $('#data-table tbody').on('ifChanged', 'input', function (event) {

            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#data-table'));
        });

        $(window).on('resize', function () {
            $('#data-table').css("width", "100%");
        });

        
    });
</script>
