<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-envelope-letter"></i>
                    پیام ها 
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row text-center">
                <div class="col-md-6">
                    <span>موضوع: </span>
                    <span class="bold"><?= html_escape($ticket->title) ?></span>
                </div><!-- /.col -->
                <div class="col-md-6">
                    <span>کاربر:</span>
                    <?php if(in_array('customers_edit', $user_permissions)): ?>
                        <a href="<?= base_url('admin/customers/edit/' . $ticket->user_id) ?>" target="_blank">
                            <?= html_escape("$ticket->user_first_name $ticket->user_last_name")?>
                            (<?= $ticket->user_username ?>)
                        </a>
                    <?php else: ?>
                        <span>
                            <?= html_escape("$ticket->user_first_name $ticket->user_last_name")?>
                            (<?= $ticket->user_username ?>)
                        </span>
                    <?php endif; ?>
                    <?php if($ticket->user_status == 'accept'): ?>
                        <span class="label label-success">تایید شده</span>
                    <?php else: ?>
                        <span class="label label-danger">تایید نشده</span>
                    <?php endif ?>
                </div><!-- /.col -->
            </div><!-- /.row -->
            <hr>
            <div class="row">
                <div class="discussion-con col-sm-12 col-md-10 col-md-offset-1">
                    <ul class="discussion">
                        <?php if ($messages) : ?>
                            <?php foreach ($messages as $item) : ?>
                                <?php
                                $sender = ($item->user_id != $ticket->user_id) ? 'self' :'other';
                                $senedr_name = html_escape("$item->user_first_name $item->user_last_name");
                                ?>
                                <li class="<?= $sender ?>" data-id="<?= $item->id ?>">
                                    <div class="avatar">
                                        <img src="<?= base_url($item->user_image) ?>" alt="<?= $senedr_name ?>" title="<?= $senedr_name ?>">
                                    </div>
                                    <div class="message">
                                        <div class="content">
                                            <?= nl2br(html_escape($item->text)) ?>
                                        </div><!-- /content -->
                                        <div class="box-message-edit hidden">
                                            <textarea class="form-control" ><?= html_escape($item->text) ?></textarea>
                                        </div>
                                        <span class="sender-name">
                                            <i class="icon-pencil"></i>
                                            <?= $senedr_name . ' در ' ?>
                                        </span>
                                        <time><?= $item->created ?></time>
                                        <?php if($item->user_id != $ticket->user_id): ?>
                                            <div>
                                                <?php if(in_array('messages_edit', $user_permissions)): ?>
                                                    <a href="javascript:void(0);" class="btn btn-sm btn-round btn-success btn-save has-tooltip hidden btn-message-save" onclick="messageUpdate('<?=$item->id?>')"  rel="tooltip" title="ذخیره">
                                                        <i class="fa fa-save"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" class="btn btn-sm btn-round btn-warning btn-edit has-tooltip btn-message-edit" onclick="messageEdit('<?=$item->id?>')" title="ویرایش">
                                                        <i class="icon-pencil"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if(in_array('messages_delete', $user_permissions)): ?>
                                                    <a href="javascript:void(0);" class="btn btn-sm btn-danger btn-round has-tooltip message-delete" onclick="messageDelete('<?=$item->id?>')" title="حذف پیام">
                                                        <i class="icon-trash"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if($item->reading): ?>
                                                    <span class="pull-left text-success has-tooltip" title="مشاهده کرده"><i class="icon-check"></i></span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($item->attach && file_exists($item->attach)): ?>
                                            <a href="<?= base_url("admin/tickets/download/$item->id") ?>" class="btn btn-info btn-sm round pull-left">
                                                <i class="icon-cloud-download"></i>
                                                پیوست
                                            </a>
                                        <?php endif ?>

                                    </div><!-- /message -->
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                    <?php if ($this->session->flashdata('admin_error')): ?>
                        <div class="alert alert-danger curve m-t-15 m-b-15 fill">
                            <p><?= $this->session->flashdata('admin_error') ?></p>
                        </div>
                    <?php endif; ?>
                    <div class="form-box">
                        <form class="center-block" id="form-data" role="form" method="POST">
                            <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                            <?php if(in_array('messages_add', $user_permissions)): ?>
                                <input type="hidden" name="ticket_id" value="<?= $ticket->id ?>">
                                <div class="input-group round">
                                    <span class="input-group-addon">
                                        <i class="icon-pencil"></i>
                                    </span>
                                    <textarea name="text" id="comment" rows="5" class="form-control" placeholder="پیام جدید"></textarea>
                                </div><!-- /.input-group -->
                                <p class="m-t-20">فایل پیوست (پسوند های مجاز: docx, txt, pptx, ppt, zip, pdf, jpg, jpeg, png) (حداکثر سایز: 10 MB)</p>
                                <div class="input-group round">
                                    <span class="input-group-addon">
                                        <i class="icon-cloud-upload"></i>
                                    </span>
                                    <input type="file" class="form-control ltr" name="attach">
                                </div><!-- /.input-group -->

                                <div class="text-center m-t-10">
                                    <a href="javascript: void(0)" class="btn btn-info btn-round btn-save" onclick="insert('<?= base_url('admin/tickets/messageSave/'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert');">
                                        <i class="icon-check"></i>
                                        ارسال پیام
                                    </a>
                                </div>
                            <?php endif; ?>
                        </form>
                    </div><!-- /.form-box -->
                    <hr>
                    <div class="text-center m-b-40">
                        <?php if(in_array('orders', $user_permissions)): ?>
                            <a href="<?= base_url("admin/orders/index/$ticket->user_id") ?>" class="btn btn-info btn-round m-b-10" target="_blank" ><i class="icon-basket-loaded fa-flip-horizontal"></i> سفارشات کاربر</a>
                        <?php endif; ?>
                        <a href="<?= base_url("admin/tickets/index/$ticket->user_id") ?>" class="btn btn-primary btn-round m-b-10" target="_blank" ><i class="icon-cursor fa-flip-horizontal"></i> تیکت های کاربر </a>
                        <?php if(in_array('tickets_edit', $user_permissions)): ?>
                            <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/tickets/changeStatus/open/'. $ticket->id) ?>', '#form-data', '', '', '#msg', false, true, 'noty')" class="btn btn-danger btn-round btn-ticket-open m-b-10 <?php if($ticket->status != 'close') echo 'hide'; ?>">
                                <i class="icon-lock-open"></i>
                                باز کردن تیکت
                            </a>
                            <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/tickets/changeStatus/close/'. $ticket->id) ?>', '#form-data', '', '', '#msg', false, true, 'noty')" class="btn btn-success btn-round btn-ticket-close m-b-10 <?php if($ticket->status == 'close') echo 'hide'; ?>">
                                <i class="icon-lock"></i>
                                بستن تیکت
                            </a>
                        <?php endif; ?>
                        <a href="<?= base_url('admin/tickets') ?>" class="btn btn-warning btn-round m-b-10">
                            <i class="icon-close"></i>
                            بازگشت
                        </a>
                    </div><!-- /.col -->
                </div><!-- /.col .discussion-con -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
<script>
    $(document).ready(function() {
        <?php if (isset($first_message_unread)) : ?>
            var position_message = $("li[data-id='<?= $first_message_unread ?>']").offset().top - 200;
        <?php else : ?>
            var position_message = $("textarea[id='comment']").offset().top - 400;
        <?php endif; ?>
        $('html, body').animate({
            scrollTop: position_message
        }, 'fast');
    });

    //حذف پیام
    function messageDelete(messageId){
        swal({
            title: "این عملیات برگشت پذیر نیست!",
            text: "آیا اطمینان دارید پیام مورد نظر حذف شود؟",
            type: "error",
            showCancelButton: true,
            confirmButtonColor: "#f44336",
            confirmButtonText: 'بله',
            cancelButtonText: "انصراف",
            cancelButtonColor: '#55b559',
            closeOnConfirm: false,
            closeOnCancel: true //false
        }).then(function() {
            $.ajax({
                url: baseUrl + 'admin/tickets/messageDelete/'+messageId,
                success: function(data)
                {
                    var result = JSON.parse(data);
                    if (result.condition == true) {
                        $('li[data-id="'+messageId+'"]').remove();

                        if(result.msg){
                            generateType('success', result.msg, 'bottomLeft');
                        }

                        if (typeof result.url !== 'undefined') {
                            window.location.assign(result.url);
                        }
                    }else {
                        generateType('error', result.msg, 'bottomLeft');
                        return false;
                    }
                }
            });
        }, function(dismiss) {

        });     
    }
    
    //نمایش فرم ویرایش پیام
    function messageEdit(messageId){
        var item=$('li[data-id="'+messageId+'"]');
        
        //پنهان کردن دکمه ویرایش و متن پیام
        $(item).find('.message .btn-message-edit').addClass('hidden');
        $(item).find('.message .content').addClass('hidden');
        
        //آشکار کردن دکمه ذخیره و جعبه متن
        $(item).find('.message .btn-message-save').removeClass('hidden');
        $(item).find('.message .box-message-edit').removeClass('hidden');
        
        //بردن کرسر به آخر متن 
        $(item).find('.message .box-message-edit textarea').focus();
        $(item).find('.message .box-message-edit textarea').val($(item).find('.message .box-message-edit textarea').val()+' ');
        
    }
    
    //ویرایش پیام
    function messageUpdate(messageId){
        var item=$('li[data-id="'+messageId+'"]');
        var text=$(item).find('textarea').val();
        $.ajax({
            type: "POST",
            url: baseUrl + 'admin/tickets/messageSave',
            async: false,
            data: {
                <?= $this->security->get_csrf_token_name() ?> : $("input[name='" + csrfTokenName + "']").val(),
                message_id : messageId,
                ticket_id : '<?=$ticket->id?>',
                text : text
            },
            success: function(data)
            {
                var result = JSON.parse(data);
                if (result.condition == true) {
                    
        
                    //آشکار کردن دکمه ویرایش و متن پیام
                    $(item).find('.message .btn-message-edit').removeClass('hidden');
                    $(item).find('.message .content').removeClass('hidden');

                    //پنهان کردن دکمه ذخیره و جعبه متن
                    $(item).find('.message .btn-message-save').addClass('hidden');
                    $(item).find('.message .box-message-edit').addClass('hidden');

                    //به روز کردن متن پیام
                    $(item).find('.message .content').html($(item).find('.message .box-message-edit textarea').val().replace(/\r\n|\r|\n/g,"<br />"));
                } else {
                    return false;
                }
                
            }
        }); 
    
    }
</script>