<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-layers"></i>
                    محصولات
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col col-md-12">
                    <?php if (in_array('products_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/products/edit') ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('products_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/products/publish'); ?>', '#frm-main', '<?php echo base_url('admin/products/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="انتشار">
                            <i class="icon-eye"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/products/un_publish'); ?>', '#frm-main', '<?php echo base_url('admin/products/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم انتشار">
                            <i class="icon-eye"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('products_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?php echo base_url('admin/products/delete'); ?>', '#frm-main', '<?php echo base_url('/admin/products/view'); ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- col -->
            </div><!-- row -->
            <div>
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids"/>
                </form>
            </div>
            <br>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="product-table">
                    <tfoot class="top-search">
                        <tr>
                            <th class="no-search"></th>
                            <th class="no-search"></th>
                            <th></th>
                            <th></th>
                            <th class="equal"></th>
                            <th class="no-search"></th>
                        </tr>
                    </tfoot>
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th>عنوان</th>
                            <th>دسته</th>
                            <th style="width:50px;">موجودی</th>
                            <th style="width:170px;">عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->
            <div class="alert alert-info">
                <p>
                    <span>توجه:</span>
                    <span>کارت های که قفل هستند(کاربر در حال خرید آن است) جز موجودی حساب می شوند و کارت های که فروش رفته اند جز موجودی حساب نمی شوند.</span>
                </p>
            </div>
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    var tableMain = '';
    var dataSet = new Array();
    <?php if ($products): ?>
        <?php foreach ($products as $item): ?>
            <?php
                $item->title = preg_replace('/[^a-z0-9A-Z۱۲۳۴۵۶۷۸۹۰ يكئ آابپتثجچحخدذرزژسشصضطظعغفقکگلمنوهی]/', '', $item->title);
                $item->category_title = preg_replace('/[^a-z0-9A-Z۱۲۳۴۵۶۷۸۹۰ يكئ آابپتثجچحخدذرزژسشصضطظعغفقکگلمنوهی]/', '', $item->category_title);
            ?>
            var item = new Array(
                "",
                "<?= $item->id ?>",
                "<?= $item->title ?>",
                "<?= $item->category_title ?>",
                "<?= $item->number_of_cards ?>",
                "",
                "<?= $item->is_exists ?>",
                "<?= $item->publish ?>"
            );
            dataSet.push(item);
        <?php endforeach; ?>
    <?php endif; ?>
    let canEdit = Number('<?= (in_array('products_edit', $user_permissions)) ? 1 : 0 ?>');
    let canDelete = Number('<?= (in_array('products_delete', $user_permissions)) ? 1 : 0 ?>');
    $(document).ready(function() {
        var selectedMain = [];

        $('#product-table tfoot th').each(function() {
            if(!$(this).hasClass("no-search")){
                var title = $('#product-table thead th').eq($(this).index()).text();
                $(this).html('<input type="text" class="form-control" style="width:100%" placeholder="' + title + '" />');
            }
        });

        var tableMain = $('#product-table').DataTable({
            "data": dataSet,
            // "stateSave": true,
            "pageLength": 25,
            "columns": [
                { "orderable": false, "searchable": false, "class": "width-10 p-10"},
                { "orderable": false, "searchable": false, "class": "width-10"},
                { "orderable": true, "searchable": true },
                { "orderable": true, "searchable": true },
                { "orderable": true, "searchable": true },
                { "orderable": false, "searchable": false }
            ],
            "order":[],
            "createdRow": function ( row, data, index, iDisplayIndexFull ) {
                // td:nth-child(i), data[j]
                //i = 1 || j = 0 => checkbox
                //i = 2 || j = 1 => id & no
                //i = 3 || j = 2 => title
                //i = 4 || j = 3 => category_title
                //i = 5 || j = 4 => number_of_cards
                //i = 6 || j = 5 => actions
                //i = 7 || j = 6 => is_exists
                //i = 8 || j = 7 => publish

                let id = data[1];
                let isExists = data[6];
                let publish = data[7];

                // Checkbox
                $(row).find("td:nth-child(1)").html('<input type="checkbox" value="'+id+'">');

                $(row).find("td:nth-child(2)").html(index + 1);

                let action = "";
                if(canEdit){

                    action += '<a title="ویرایش" class="btn btn-warning btn-round btn-icon has-tooltip" href="'+baseUrl+'admin/products/edit/'+id+'" ><i class="icon-pencil"></i></a> ';
                    
                    // Publish
                    if (publish == 1) {
                        var btnClass = 'success';
                        var title = 'انتشار';
                        var url = baseUrl + 'admin/products/un_publish/' + id;
                    } else {
                        var btnClass = 'danger';
                        var title = 'عدم انتشار';
                        var url = baseUrl + 'admin/products/publish/' + id;
                    }
                    action += "<a title=\""+title+"\" class=\"btn btn-"+btnClass+" btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"insert('"+url+"','#frm-main','"+baseUrl+"admin/products/view','#res','#msg',false, true, 'noty', 'GET')\"><i class=\"icon-eye\"></i></a> ";

                    // Exists
                    if (isExists == 1) {
                        var icon = 'icon-check';
                        var btnClass = 'success';
                        var title = 'موجود';
                        var url = baseUrl + 'admin/products/onExist/' + id;
                    } else {
                        var icon = 'icon-close';
                        var btnClass = 'danger';
                        var title = 'نا موجود';
                        var url = baseUrl + 'admin/products/exist/' + id;
                    }
                    action += "<a title=\""+title+"\" class=\"btn btn-"+btnClass+" btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"insert('"+url+"','#frm-main','"+baseUrl+"admin/products/view','#res','#msg',false, true, 'noty', 'GET')\"><i class=\""+icon+"\"></i></a> ";
                }

                if(canDelete){
                    action += "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('"+baseUrl+"admin/products/delete/"+id+"','#frm-main','"+baseUrl+"admin/products/view','#res','delete')\"><i class=\"icon-trash\"></i></a> ";
                }
                $(row).find("td:nth-child(6)").html(action);
            },
            "drawCallback": function(settings, start) {
                $(".has-tooltip").tooltip();
                window.Modiran.initiCkeck();
                chackAllStatus($('#product-table'));
            },
            "sPaginationType": "full_numbers",
        });
        
        tableMain.on('order.dt search.dt', function () {
            tableMain.column(1, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            });
        });

        // Restore state
        // var state = tableMain.state.loaded();
        // if (state) {
        //     tableMain.columns().eq(0).each(function(colIdx) {
        //         var colSearch = state.columns[colIdx].search;
        //         if (colSearch.search) {
        //             var firstChar = colSearch.search.slice(0, 1);
        //             var lastChar = colSearch.search.slice(-1);
        //             if(firstChar == '^' && lastChar == '$'){
        //                 colSearch.search = colSearch.search.slice(1, colSearch.search.length-1);
        //             }
        //             $('input', tableMain.column(colIdx).footer()).val(colSearch.search);
        //         }
        //     });
        //     tableMain.column(1, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
        //         cell.innerHTML = i+1;
        //     });
        // }

        tableMain.columns().eq(0).each(function (colIdx) {
            $(':input', tableMain.column(colIdx).footer()).on('keyup change', function () {
                var parentClass = $(this).parent().attr("class");
                if (parentClass == "equal") {
                    // جستجوی کد دقیقا یکسان
                    tableMain.column(colIdx)
                        .search(
                            ($(this).val()) ? "^" + $(this).val() + "$" : $(this).val(),
                            true,
                            false,
                            false);
                    tableMain.draw();
                }else{
                    // جستجوی عبارت مشابه
                    tableMain
                        .column(colIdx)
                        .search(this.value)
                        .draw();
                }
            });
        });

        // Select checkboxes
        $('#product-table tbody').on('ifChanged', 'input', function (event) {

            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#product-table'));
        });

        $(window).on('resize', function() {
            $('#product-table').css("width", "100%");
        });

    });
</script>
