<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$product->id = intval($product->id);
?>
<?php if($categories) : ?>
    <style>
        .box-price {
            position: relative;
        }

        .box-old-image a,
        .btn-icon.remove-price {
            position: absolute;
            top: -15px;
            left: -15px;
            text-align: center;
            z-index: 1;
            outline: none !important;
            height: 30px;
            width: 30px;
            line-height: 28px;
        }
    </style>

    <form id="form-data" role="form" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
        <input type="hidden" id="txt-id" value="<?= $product->id ?>" name="product[id]">
        <div class="col-md-12">
            <div class="portlet box border shadow">
                <div class="portlet-heading">
                    <div class="portlet-title">
                        <h3 class="title">
                            <i class="<?= $product->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                            <?= $product->id == 0 ? 'محصول جدید' : 'ویرایش محصول' ?>
                        </h3>
                    </div><!-- /.portlet-title -->
                    <div class="buttons-box">
                        <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                            <i class="icon-arrow-up"></i>
                        </a>
                    </div><!-- /.buttons-box -->
                </div><!-- /.portlet-heading -->
                <div class="portlet-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-body">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>دسته بندی</label><span class="text-danger">*</span>
                                        <select class="form-control" name="product[category_id]" id="category">
                                            <?php
                                            foreach ($categories as $category) {
                                                $selected = ($product->category_id == $category->id) ? ' selected' : '';
                                            ?>
                                                <option value="<?= $category->id ?>" <?= $selected ?>><?= $category->title_fa ?></option>
                                            <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>عنوان</label><span class="text-danger">*</span>
                                        <input type="text" class="form-control" name="product[title]" value="<?= $product->title ?>" />
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-md-12 m-b-10">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Slug (فاصله ها با - جایگزین خواهند شد)</label>
                                                <input type="text" class="form-control" id="txt-slug" name="product[slug]" value="<?= $product->slug ?>" placeholder="">
                                            </div><!-- ./form-group -->
                                            <div class="input-group curve">
                                                <input type="text" id="txt-link" class="form-control ltr" value="<?= getProductSlug($product->slug, $product->id) ?>" readonly>
                                                <span class="input-group-btn">
                                                    <button id="btn-copy-link" class="btn btn-primary" type="button" ><i class="icon-docs"></i> کپی لینک محصول</button>
                                                </span>
                                            </div><!-- ./input-group -->
                                        </div><!-- ./col -->
                                    </div><!-- ./row -->
                                </div><!-- ./col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>ویژه؟</label>
                                        <select class="form-control" name="product[is_special]">
                                            <option value="0" <?php if (!$product->is_special) echo 'selected'; ?>>محصول عادی</option>
                                            <option value="1" <?php if ($product->is_special) echo 'selected'; ?>>محصول ویژه</option>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>وضعیت موجودی</label>
                                        <select class="form-control" name="product[is_exists]">
                                            <option value="1" <?php if ($product->is_exists == 1) echo 'selected'; ?>>موجود</option>
                                            <option value="0" <?php if ($product->is_exists == 0) echo 'selected'; ?>>ناموجود</option>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>وضعیت انتشار</label>
                                        <select class="form-control" name="product[publish]">
                                            <option value="1" <?php if ($product->publish == 1) echo 'selected'; ?>>انتشار</option>
                                            <option value="0" <?php if ($product->publish == 0) echo 'selected'; ?>>عدم انتشار</option>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>
                                            زمان و نحوه نمایش اطلاعات کارت
                                            <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-manual-product"><i class="fa fa-question"></i></a>
                                        </label>
                                        <select class="form-control" name="product[manual]">
                                            <option value="1" <?php if ($product->manual == 1) echo 'selected'; ?>>با تاخیر و بعد از تایید سفارش توسط ادمین</option>
                                            <option value="0" <?php if ($product->manual == 0) echo 'selected'; ?>>آنی نمایش داده شود</option>
                                            <option value="2" <?php if ($product->manual == 2) echo 'selected'; ?>>فقط برای کاربران تایید شده توسط ادمین، آنی باشد</option>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>حداقل تعداد خرید کارت‌ در یک سفارش <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control numeric ltr text-left" name="min_qty" value="<?= ($product->min_qty) ? $product->min_qty : '' ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>حداکثر تعداد خرید کارت‌ در یک سفارش <small>(صفر یا خالی به معنای تمام موجودی است)</small></label>
                                        <input type="text" class="form-control numeric ltr text-left" name="max_qty" value="<?= ($product->max_qty) ? $product->max_qty : '' ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>ترتیب نمایش<span class="text-danger">*</span></label>
                                        <input type="number" class="form-control numeric" name="ordering" value="<?= $product->ordering ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="clearfix"></div>
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <p>در صورتی که تصاویر زیر را وارد نکنید تصویر دسته انتخاب شده نمایش داده خواهد شد و سرعت بارگذاری سایت شما سریع تر می شود.</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group box-image">
                                        <label>عکس کوچک <span>(80x80)</span> پیکسل <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-ui"><i class="fa fa-question"></i></a></label>
                                        <?php
                                        $class_hide = '';
                                        if ($product->image && file_exists($product->image)) {
                                            $image = base_url() . $product->image;
                                            $class_hide = 'hide';
                                        ?>
                                            <div class="box-old-image">
                                                <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/products/removeImage/$product->id"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                                <img class="img-responsive img-thumbnail" src="<?= $image ?>">
                                            </div>
                                        <?php
                                        }
                                        ?>
                                        <div class="box-new-image <?= $class_hide ?>">
                                            <input type="file" class="form-control ltr" name="image">
                                        </div>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">        
                                    <div class="form-group box-image">
                                        <label>عکس بزرگ <span>(480x360)</span> پیکسل <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-ui"><i class="fa fa-question"></i></a></label>
                                        <?php
                                        $class_hide = '';
                                        if ($product->large_image && file_exists($product->large_image)) {
                                            $image = base_url() . $product->large_image;
                                            $class_hide = 'hide';
                                        ?>
                                            <div class="box-old-image">
                                                <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/products/removeLargeImage/$product->id"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                                <img class="img-responsive img-thumbnail" src="<?= $image ?>" width="150">
                                            </div>
                                        <?php
                                        }
                                        ?>
                                        <div class="box-new-image <?= $class_hide ?>">
                                            <input type="file" class="form-control ltr" name="large_image">
                                        </div>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>توضیحات</label>
                                        <textarea name="product[front_description]" class="hide" id="content1"><?= $product->front_description ?></textarea>
                                        <div id="editor1"></div>
                                    </div><!-- /.form-group -->
                                    <div class="form-group">
                                        <label for="meta_title">متای عنوان(عنوان  مختصر و مفید تا حدود 65 حرف)</label>
                                        <input id="meta_title" name="meta_title" class="form-control" value="<?= $product->meta_title ?>">
                                    </div><!-- /.form-group -->
                                    <div class="form-group">
                                        <label for="meta_description">متای توضیحات(حدود 155 حرف)</label>
                                        <textarea id="meta_description" name="meta_description" rows="4" class="form-control"><?= $product->meta_description ?></textarea>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                            </div><!-- /.form-body -->
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.portlet-body -->
            </div><!-- /.portlet -->
        </div><!-- /.col -->

        <div class="col-md-12">
            <div class="portlet box border shadow">
                <div class="portlet-heading">
                    <div class="portlet-title">
                        <h3 class="title">
                            <i class="icon-bag"></i>
                            قیمت گذاری
                        </h3>
                    </div><!-- /.portlet-title -->
                    <div class="buttons-box">
                        <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                            <i class="icon-arrow-up"></i>
                        </a>
                    </div><!-- /.buttons-box -->
                </div><!-- /.portlet-heading -->
                <div class="portlet-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>ارز <span class="text-danger">*</span></label>
                                <select class="form-control" id="slc-currency" name="product[currency]">
                                    <option value="tooman" <?php if ($product->currency == 'tooman') echo 'selected'; ?>>تومان</option>
                                    <option value="dollar" <?php if ($product->currency == 'dollar') echo 'selected'; ?>>دلار</option>
                                    <option value="dirham" <?php if ($product->currency == 'dirham') echo 'selected'; ?>>درهم</option>
                                    <option value="euro" <?php if ($product->currency == 'euro') echo 'selected'; ?>>یورو</option>
                                    <option value="pound" <?php if ($product->currency == 'pound') echo 'selected'; ?>>پوند</option>
                                    <option value="lira" <?php if ($product->currency == 'lira') echo 'selected'; ?>>لیر</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                حداقل یک ردیف قیمت باید وجود داشته باشد.<br>
                                اولین ردیف باید با عدد یک شروع شود و برای نمایش بی نهایت در بخش "تا تعداد" از جای خالی استفاده کنید.
                            </div>
                            <div class="form-body">

                                <div class="col-md-12" id="prices">
                                    <?php
                                    if ($prices) {
                                        foreach ($prices as $price) {
                                    ?>
                                            <div class="row box-price border curve m-b-20">
                                                <a href="javascript:void(0);" class="btn-danger btn-round btn-icon remove-price has-tooltip" data-url="<?= base_url("admin/services/removePrice/$price->id"); ?>" title="حذف"><i class="icon-trash"></i></a>
                                                <input class="field-id" type="hidden" name="price_id[]" value="<?= $price->id ?>">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>از تعداد </label>
                                                        <input type="text" class="form-control ltr numeric separate field-from-qty" name="from_qty[]" value="<?= $price->from_qty ?>" placeholder="از">
                                                    </div><!--./form-group-->
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>تا تعداد </label>
                                                        <input type="text" class="form-control ltr numeric separate field-to-qty" name="to_qty[]" value="<?= $price->to_qty ?>" placeholder="تا">
                                                    </div><!--./form-group-->
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>قیمت(<span class="currency-title"><?= translateCurrency($product->currency) ?></span>)</label>
                                                        <input type="text" class="form-control ltr numeric-float separate field-sell-price" name="sell_price[]" value="<?= ($price->sell_price - floor($price->sell_price) == 0) ? number_format($price->sell_price) : number_format($price->sell_price, 2) ?>" placeholder="قیمت">
                                                    </div><!--./form-group-->
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>قیمت خط خورده(<span class="currency-title"><?= translateCurrency($product->currency) ?></span>)</label>
                                                        <?php
                                                        $value = '';
                                                        if ($price->sell_price != $price->price && $price->price != 0) {
                                                            $value = ($price->price - floor($price->price) == 0) ? number_format($price->price) : number_format($price->price, 2);
                                                        }
                                                        ?>
                                                        <input type="text" class="form-control ltr numeric-float separate field-price" name="price[]" value="<?= $value ?>" placeholder="قیمت خط خورده">
                                                    </div><!--./form-group-->
                                                </div>
                                            </div><!-- /.row -->
                                    <?php
                                        }
                                    }
                                    ?>
                                </div><!-- /.col -->
                                <a href="javascript:void(0)" class="btn btn-success btn-round inc-price">قیمت جدید</a>
                            </div><!-- /.form-body -->
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.portlet-body -->
            </div><!-- /.portlet -->
        </div><!-- /.col -->
        <div class="col-md-12">
            <div class="portlet box border shadow">
                <div class="form-actions">
                    <a href="javascript: void(0)" class="btn btn-info btn-round btn-save">
                        <i class="icon-check"></i>
                        ذخیره
                    </a>
                    <a href="<?= base_url("admin/products") ?>" class="btn btn-warning btn-round pull-left">
                        <i class="icon-close"></i>
                        بازگشت
                    </a>
                </div><!-- /.form-actions -->
            </div><!-- /.portlet -->
        </div><!-- /.col -->
    </form>
    <div id="sample-price" class="hidden">
        <div class="row box-price border curve m-b-20">
            <a href="javascript:void(0);" class="btn-danger btn-round btn-icon remove-price has-tooltip" data-url="" title="حذف"><i class="icon-trash"></i></a>
            <input class="field-id" type="hidden" name="price_id[]" value="">
            <div class="col-md-3">
                <div class="form-group">
                    <label>از تعداد </label>
                    <input type="text" class="form-control ltr numeric separate field-from-qty" name="from_qty[]" value="" placeholder="از">
                </div><!--./form-group-->
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>تا تعداد </label>
                    <input type="text" class="form-control ltr numeric separate field-to-qty" name="to_qty[]" value="" placeholder="تا">
                </div><!--./form-group-->
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>قیمت(<span class="currency-title"></span>)</label>
                    <input type="text" class="form-control ltr numeric-float separate field-sell-price" name="sell_price[]" value="" placeholder="قیمت">
                </div><!--./form-group-->
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>قیمت خط خورده(<span class="currency-title"></span>)</label>
                    <input type="text" class="form-control ltr numeric-float separate field-price" name="price[]" value="" placeholder="قیمت خط خورده">
                </div><!--./form-group-->
            </div>
        </div><!-- /.row -->
    </div><!--/#sample-price-->

    <script>
        $(document).ready(function() {
            setDefaultPrices();

            $("#slc-currency").change(function() {
                $("#prices .box-price .currency-title").text($("#slc-currency option:selected").text());
            });

            $(".inc-price").click(function() {
                newRow = $("#sample-price .box-price").clone();
                $("#prices").append(newRow);

                var target = $("#prices").find(".box-price").last();
                $(target).find("input.field-id").attr("name", "price_id[]");
                $(target).find("input.field-sell-price").attr("name", "sell_price[]");
                $(target).find("input.field-price").attr("name", "price[]");
                $(target).find("input.field-from-qty").attr("name", "from_qty[]");
                $(target).find("input.field-to-qty").attr("name", "to_qty[]");
                $(target).find(".currency-title").text($("#slc-currency option:selected").text());
                setDefaultPrices();

            });

            $(document).on("click", ".remove-price", function() {
                $(this).closest(".box-price").remove();
                setDefaultPrices();
            });

            function setDefaultPrices() {
                $(".field-from-qty, .field-to-qty").removeAttr("readonly");

                var selector = $("#prices").find(".field-from-qty");
                if (selector.length) {
                    selector.first().val(1).attr("readonly", "readonly");
                }

                var selector = $("#prices").find(".field-to-qty");
                if (selector.length) {
                    selector.last().val("").attr("readonly", "readonly");
                }
            }

            function checkPrices() {
                var condition = true;
                var message = "";
                if ($("#prices .box-price").length) {
                    var selector = $("#prices").find(".field-from-qty");
                    if (selector.length) {
                        if (selector.first().val() != "1") {
                            message += "اولین سطر قیمت باید از عدد یک شروع شود." + "\n";
                            condition = false;
                        }
                    }

                    var selector = $("#prices").find(".field-to-qty");
                    if (selector.length) {
                        if (selector.last().val() != "") {
                            message += "آخرین سطر قیمت باید خالی باشد." + "\n";
                            condition = false;
                        }
                    }

                    if (selector.length > 1) {
                        for (i = 0; i < selector.length - 1; i++) {
                            var endCurrent = parseInt($("#prices .box-price").eq(i).find(".field-to-qty").val());
                            var beginNext = parseInt($("#prices .box-price").eq(i + 1).find(".field-from-qty").val());

                            if (endCurrent !== beginNext - 1) {
                                message += "ترتیب رعایت نشده است." + "\n";
                                condition = false;
                                break;
                            }
                        }
                    }


                    var selector = $("#prices").find(".field-sell-price");
                    for (i = 0; i < selector.length; i++) {
                        if (selector.eq(i).val() == "") {
                            condition = false;
                            message += "وارد کردن قیمت اصلی محصول الزامی است.";
                        }
                    }

                } else {
                    condition = false;
                    message += "قیمتی برای محصول تعریف نشده است.";
                }

                if (!condition) {
                    swal("", message, "error");
                }

                return condition;
            }

            // Slug start
            $("#btn-copy-link").on("click", function() {
                let textBox = document.getElementById("txt-link");
                textBox.select();
                document.execCommand("copy");
                generateType('success', 'با موفقیت کپی شد', 'bottomLeft');
            });

            $("#txt-slug").on("keyup", function(e) {
                let slug = $(this).val();
                slug = slug.trim();
                slug = slug.replace(/\s+/g, '-');
                slug = slug.replace(/[،,;()*.'"]/g, "");

                if(slug == ''){
                    if($("#txt-id").val()){
                        $("#txt-link").val(baseUrl + 'product/' + $("#txt-id").val());
                    } else {
                        $("#txt-link").val('');
                    }
                } else {
                    slug = encodeURIComponent(slug);
                    $("#txt-link").val(baseUrl + 'product/' + slug);
                }
            });

            // Slug end

            var editor1;
            var config = {};

            //to enable uplaod image plugin
            config.extraPlugins = 'simage';
            config.imageUploadURL = baseUrl + 'admin/media/upload_ckeditor/';
            config.dataParser = function(data) {
                return data.url;
            };
            
            config.ContentLangDirection = 'rtl';
            config.language = 'fa';
            config.font_names =
                    "Tahoma;" +
                    "Nazanin/Nazanin, B Nazanin, BNazanin;" +
                    "Yekan/Yekan, BYekan, B Yekan, Web Yekan;" +
                    "IranSans/IranSans;" +
                    "Parastoo/Parastoo;" +
                    "Arial/Arial, Helvetica, sans-serif;" +
                    "Times New Roman/Times New Roman, Times, serif;";

            editor1 = CKEDITOR.appendTo('editor1', config);
            editor1.setData($("#content1").val());

            $(document).on("click", ".btn-save", function () {
                if (checkPrices()) {
                    $("#content1").val(editor1.getData());
                    insert('<?= base_url("admin/products/save"); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')
                }
            });
        });
    </script>
<?php else : ?>
    <div class="col-md-12">
        <div class="portlet box border shadow">
            <div class="portlet-body">
                <div class="alert alert-info b-t-20">
                    تا کنون هیچ دسته ای ثبت نشده است، بنابراین امکان تعریف محصول وجود ندارد. برای تعریف دسته از دکمه زیر استفاده کنید.
                </div>
                <a class="btn btn-info btn-round" href="<?= base_url() . 'admin/tree_categories/edit/product' ?>">افزودن دسته</a>
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
    </div><!-- /.col -->
<?php endif; ?>