<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
$user_id = ($user) ? $user->id : '';
?>

<style>
    #data-table{
        width: 100% !important;
    }
    #data-table>tfoot>tr>th{
        padding: 5px !important;
    }
    #data-table>tfoot>tr>th select{
        -webkit-appearance: none;
    }
</style>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-basket-loaded fa-flip-horizontal"></i>
                    سفارشات
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">
                    <?php if($user): ?>
                        <div>
                            <span>سفارشات</span>
                            <strong>(<?= html_escape("$user->full_name $user->cell_phone") ?>)</strong>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->session->flashdata('error') != false): ?>
                        <div class="alert alert-danger">
                            <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>
                    <?php if(!$user): ?>
                        <?php if (in_array('orders_email', $user_permissions)) : ?>
                            <a href="<?= base_url('admin/orders/exportEmails') ?>"  class="btn btn-primary btn-round  has-tooltip" title="دانلود فایل اکسل ایمیل ها">
                                <i class="icon-cloud-download"></i>
                                ایمیل ها
                            </a>
                        <?php endif; ?>
                        <?php if (in_array('orders_phone', $user_permissions)) : ?>
                            <a href="<?= base_url('admin/orders/exportCellPhones') ?>"  class="btn btn-primary btn-round  has-tooltip" title="دانلود فایل اکسل شماره همراه ها">
                                <i class="icon-cloud-download"></i>
                                شماره همراه ها
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div><!-- /.col -->
            </div><!-- /.row -->
            <div class="m-t-10">
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids">
                </form>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="data-table">
                    <tfoot class="top-search">
                        <tr>
                            <th></th>
                            <!-- <th></th> -->
                            <th class="searchable" data-width="75"></th>
                            <th class="searchable" data-width="120"></th>
                            <th class="searchable" data-width="90"></th>
                            <th class="searchable" data-width="70"></th>
                            <th class="searchable" data-width="70"></th>
                            <th class="select-card2card"></th>
                            <th class="select-paid"></th>
                            <th class="select-pending"></th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <thead>
                        <tr>
                            <th>#</th>
                            <!-- <th>ش. سفارش</th> -->
                            <th>ش. پیگیری</th>
                            <th>ایمیل</th>
                            <th>ش. همراه</th>
                            <th>مبلغ</th>
                            <th>کوپن</th>
                            <th><span class="font-sm">کارت به کارت / آنلاین</span></th>
                            <th><span class="font-sm">وضعیت پرداخت</span></th>
                            <th><span class="font-sm">وضعیت نمایش </span></th>
                            <th>تاریخ</th>
                            <th style="min-width:70px">عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function() {
        var selectedMain = [];
        var tableMain = $('#data-table').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "pageLength": 50,
           "columns": [
                {"data": "row", "orderable": false},
                // {"data": "id"},
                {"data": "tracking_code"},
                {"data": "email"},
                {"data": "cell_phone"},
                {"data": "price"},
                {"data": "coupon_code"},
                {"data": "card2card", "orderable": false},
                {"data": "paid", "orderable": false},
                {"data": "pending", "orderable": false},
                {"data": "jalali_created"},
                {"data": "actions", "orderable": false}
            ],
            "ajax": {
                "url": "<?php echo base_url("admin/orders/ajax_list/$user_id") ?>",
                "type": "POST",
                data: function(d) {
                    d.<?= $this->security->get_csrf_token_name() ?> = $("input[name='" + csrfTokenName + "']").val();
                },
                dataSrc: function(json) {
                    if (json.csrf !== undefined)
                        $("input[name='" + csrfTokenName + "']").val(json.csrf);
                    return json.data;
                }
            },
            "sPaginationType": "full_numbers",
            "order": [], //Initial no order.
            "fnDrawCallback": function() {
                $(".has-tooltip, table .btn").tooltip();
            }
        });


        // Resize
        $(window).on('resize', function() {
            $('#data-table').css("width", "100%");
        });


        // Add Search input, select
        $('#data-table tfoot th.searchable').each(function() {
            var title = $("#data-table thead th").eq($(this).index()).text();
            $(this).html('<input type="text" placeholder="' + title + '"  style="width:' +$(this).attr('data-width')+ 'px;">');
        });
        $('#data-table tfoot th.select-card2card').each(function() {
            $(this).html('<select style="width:65px;"><option value="">همه</option><option value="online">آنلاین</option><option value="pending">ک. در دست بررسی</option><option value="accept">ک. تایید شده</option><option value="reject">ک. لغو شده</option></select>');
        });
        $('#data-table tfoot th.select-paid').each(function() {
            $(this).html('<select style="width:65px"><option value="">همه</option><option value="1">شده</option><option value="0">نشده</option></select>');
        });
        $('#data-table tfoot th.select-pending').each(function() {
            $(this).html('<select style="width:65px"><option value="">همه</option><option value="1">درانتظار</option><option value="0">تمام شده</option></select>');
        });

        // Apply the search
        tableMain.columns().eq(0).each(function(colIdx) {
            $(':input', tableMain.column(colIdx).footer()).on('keyup change', function() {
                tableMain
                    .column(colIdx)
                    .search(this.value)
                    .draw();
            });
        });
    });
</script>
