<?php
$gift->id = intval($gift->id);
?>
<div class="col-md-8 col-md-offset-2" >
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="<?= $gift->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $gift->id == 0 ? 'کارت هدیه جدید' : 'ویرایش کارت هدیه' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <form id="form-data" role="form" method="POST">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" value="<?= $gift->id ?>" name="id">

                        <div class="form-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>عنوان</label>
                                        <input type="text" class="form-control" name="title" value="<?= $gift->title ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>کد کارت هدیه</label>
                                        <input type="text" class="form-control ltr" name="code" value="<?= $gift->code ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>مبلغ(تومان)</label>
                                        <input type="text" class="form-control numeric separate ltr" name="amount" value="<?= (is_numeric($gift->amount) ) ? number_format($gift->amount) : ''; ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>تعداد<span class="font-xs">(حداکثر تعداد کاربری که می تواند از این کارت استفاده کند)</span></label>
                                        <input type="text" class="form-control numeric ltr" name="count" value="<?= $gift->count ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="clearfix"></div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>تاریخ شروع</label>
                                        <input type="text"  class="form-control ltr" id="start-date" name="start_date" value="<?= $gift->start_date ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>تاریخ پایان</label>
                                        <input type="text"  class="form-control ltr" id="end-date" name="end_date" value="<?= $gift->end_date ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>وضعیت انتشار</label>
                                        <select  class="form-control" name="publish">
                                            <option value="1" <?php if($gift->publish == 1) echo 'selected';?> > انتشار</option>
                                            <option value="0" <?php if($gift->publish == 0) echo 'selected';?> > عدم انتشار</option>
                                        </select>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                            </div><!-- /.row -->


                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a class="btn btn-info btn-round btn-save" onclick="insert('<?= base_url('admin/gifts/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')" >
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url('admin/gifts') ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function(){
        // datepicker config
        var datepicker = $("#start-date, #end-date").pDatepicker({
            format: "YYYY/MM/DD",
            observer: true,
            autoClose: true,
            toolbox: {
                calendarSwitch: {
                    enabled: false
                },
            },
            calendar:{
                persian: {
                    leapYearMode: 'astronomical'
                }
            }
        });
    });
</script>
