<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-paypal"></i>
                    درگاه ها
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">
                    <?php if($check_card_number): ?>
                        <div class="alert alert-warning fill">
                            <p>به دلیل اینکه تطابق شماره کارت بانکی با کد ملی را در تنظیمات انتخاب کرده‌اید، فقط درگاه‌های زیر و کارت به کارت را می‌توانید فعال کنید.</p>
                            <p>
                                <?php foreach ($gateways_check_card as $item): ?>
                                    <span class="badge badge-inverse curve"><?= ucfirst($item) ?></span>
                                <?php endforeach ?>
                            </p>
                            <p>نکته مهم: تطابق شماره کارت بانکی با کد ملی برای <b>کارت به کارت</b> بررسی نمی‌شود. </p>
                        </div>
                    <?php endif ?>
                    <?php if (in_array('gateways_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/gateways/publish'); ?>', '#frm-main', '<?= base_url('admin/gateways/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="انتشار">
                            <i class="icon-eye"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/gateways/un_publish'); ?>', '#frm-main', '<?= base_url('admin/gateways/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم انتشار">
                            <i class="icon-eye"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- /.col -->

                <div class="clearfix"></div>

                <div class="col-md-12">
                    <div>
                        <div id="lbl-ids"></div>
                        <form method="post" id="frm-main">
                            <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                            <input type="hidden" id="txt-ids" name="list_ids"/>
                        </form>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover table-striped" id="data-table">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" class="check-all"></th>
                                    <th>#</th>
                                    <th class="hidden">کد</th>
                                    <th>عنوان</th>
                                    <th>عنوان فارسی</th>
                                    <th>پیش فرض</th>
                                    <th>ترتیب نمایش</th>
                                    <th style="min-width: 100px">عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($gateways): ?>
                                    <?php foreach ($gateways as $key => $gateway): ?>
                                        <?php $allow_active = ($gateway->title_en == 'card2card' || !$check_card_number || ($check_card_number && in_array($gateway->title_en, $gateways_check_card))) ? true : false; ?>
                                        <tr>
                                            <td>
                                                <?php if($allow_active): ?>
                                                    <input type="checkbox" value="<?= $gateway->id ?>">
                                                <?php endif ?>
                                            </td>
                                            <td><?= $key + 1 ?></td>
                                            <td  class="hidden"><?= $gateway->id ?></td>
                                            <td><?= $gateway->title_en ?></td>
                                            <td><?= $gateway->title_fa ?></td>
                                            <td>
                                                <?php if (in_array('gateways_edit', $user_permissions)) : ?>
                                                    <a href="javascript:void(0)" title="برای انتخاب به عنوان پیش فرض کلیک کنید" class="has-tooltip"  onclick="insert('<?= base_url("admin/gateways/defaultGateway/$gateway->id") ?>', '', '<?= base_url('admin/gateways/view') ?>', '#res', '#msg', false, true, 'noty', 'GET')">
                                                        <i class="<?= ($gateway->is_default == 1) ? 'fa fa-check-circle fa-2x text-success' : 'fa fa-circle-o fa-2x' ?>"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <span><i class="<?= ($gateway->is_default == 1) ? 'fa fa-check-circle fa-2x text-success' : 'fa fa-circle-o fa-2x' ?>"></i></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (in_array('gateways_edit', $user_permissions)) : ?>
                                                    <input type="number" value="<?= $gateway->ordering ?>"  class="form-control has-tooltip numeric" data-min="1" onblur="insert('<?= base_url("admin/gateways/ordering/$gateway->id/") ?>' + this.value, '#frm-main', '<?= base_url() ?>admin/gateways/view', '#res', '#msg', false, true, 'noty');" title="برای تغییر ترتیب نمایش بعد از اینکه آن را تغییر دادید ، خارج از جعبه متن کلیک کنید" >
                                                <?php else: ?>
                                                    <span><?= $gateway->ordering ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (in_array('gateways_edit', $user_permissions)) : ?>
                                                    <a class="btn btn-warning  btn-round btn-icon has-tooltip" title="ویرایش" href="<?= base_url('admin/gateways/edit/' . $gateway->id) ?>" ><i class="icon-pencil"></i></a>
                                                    <?php if($allow_active): ?>
                                                        <?php if ($gateway->publish == 0): ?>
                                                            <a class="btn btn-danger btn-round btn-icon has-tooltip" title="عدم انتشار" href="javascript: void(0)" onclick="insert('<?= base_url("admin/gateways/publish/" . $gateway->id) ?>', '#frm-main', '<?= base_url("admin/gateways/view") ?>', '#res', '#msg', false, true, 'noty')" ><i class="icon-eye"></i></a>
                                                        <?php else: ?>
                                                            <a class="btn btn-success btn-round btn-icon has-tooltip" title="انتشار" href="javascript: void(0)" onclick="insert('<?= base_url('admin/gateways/un_publish/') . $gateway->id; ?>', '#frm-main', '<?= base_url('admin/gateways/view'); ?>', '#res', '#msg', false, true, 'noty')"><i class="icon-eye"></i></a>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <?php if ($gateway->publish == 0): ?>
                                                            <span class="badge badge-danger curve">عدم انتشار</span>
                                                        <?php else: ?>
                                                            <span class="badge badge-success curve">انتشار</span>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div><!-- /.table-responsive -->
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<!--  Tooltip -->
<script>
    $(document).ready(function () {
        var selectedMain = [];
        var tableMain = $("#data-table").DataTable({
            "pageLength": 25,
            "rowCallback": function (row, data) {
                //window.Modiran.initiCkeck();
            },
            "drawCallback": function( settings ) {
                chackAllStatus($('#data-table'));
            },
            "sPaginationType": "full_numbers",
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false, "class": "width-10"},
                {"data": "DT_RowId"},
                {"data": "title_en"},
                {"data": "title_fa"},
                {"data": "is_default"},
                {"data": "ordering"},
                {"data": "actions", "orderable": false}
            ],
            "order": []
        });


        // Select checkboxes
        $("#data-table tbody").on("ifChanged", "input", function (event) {
            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass("selected");
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass("selected");
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#data-table'));
        });


        $(window).on("resize", function () {
            $("#data-table").css("width", "100%");
        });
    });
</script>
