<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
$customer->id = intval($customer->id);
?>
<style>
    .bank-cards ul{
        margin-top: 10px;
    }
    .bank-cards ul li{
        border: 1px solid #cbcbcb;
        border-radius: 6px;
        margin-bottom: 5px;
        
    }
    .bank-cards ul li .card-number{
        display: inline-block;
        width:calc( 100% - 50px);
        text-align: center;
    }
    .bank-cards ul li .btn-remove{
        display: inline-block;
        width: 45px;
        color: #f55145;
        padding-right: 10px;
        cursor: pointer;
    }
</style>
<form id="form-data" role="form" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
    <input type="hidden" value="<?= $customer->id ?>" name="id" />
    <div class="col-md-8">
        <div class="portlet box border shadow">
            <div class="portlet-heading">
                <div class="portlet-title">
                    <h3 class="title">
                        <i class="<?= $customer->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                        <?= $customer->id == 0 ? 'مشتری جدید' : 'ویرایش مشتری' ?>
                    </h3>
                </div><!-- /.portlet-title -->
                <div class="buttons-box">
                    <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                        <i class="icon-arrow-up"></i>
                    </a>
                </div><!-- /.buttons-box -->
            </div><!-- /.portlet-heading -->
            <div class="portlet-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-body">
    
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>شماره همراه</label>
                                        <?php if (!$customer->id) : ?>
                                            <span class="text-danger">*</span>
                                        <?php endif; ?>
                                        <input type="text" class="form-control ltr text-left numeric" maxlength="11" name="username" value="<?= $customer->username ?>" placeholder="شماره همراه" <?php if ($customer->id) echo 'disabled'; ?>>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <label>ایمیل</label>
                                        <input type="email" class="form-control ltr text-left" name="email" value="<?= html_escape($customer->email) ?>" placeholder="ایمیل">
                                    </div>
                                </div><!-- /.col -->
                            </div><!-- /.row -->
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>نام</label>
                                        <input type="text" class="form-control" name="first_name" value="<?= html_escape($customer->first_name) ?>" placeholder="نام">
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>نام خانوادگی</label>
                                        <input type="text" class="form-control" name="last_name" value="<?= html_escape($customer->last_name) ?>" placeholder="نام خانوادگی">
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>نام پدر</label>
                                        <input type="text" class="form-control" name="father_name" value="<?= html_escape($customer->father_name) ?>" placeholder="نام پدر">
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>کدملی</label>
                                        <input type="text" class="form-control ltr text-left numeric" name="national_code" value="<?= $customer->national_code ?>" placeholder="کد ملی">
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>تاریخ تولد</label>
                                        <input type="text" class="form-control ltr text-left" name="birth_date" id="txt-birth-date" autocomplete="off" value="<?= $customer->birth_date ?>" placeholder="تاریخ تولد">
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>وضعیت تایید توسط ادمین</label>
                                        <select class="form-control" name="status">
                                            <option value="accept" <?php if ($customer->status == 'accept') echo 'selected'; ?>>تایید شده</option>
                                            <option value="" <?php if ($customer->status == '') echo 'selected'; ?>>تایید نشده</option>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-12">
                                    <div class="form-group m-b-10">
                                        <label>
                                            <input type="checkbox" name="national_code_matched" value="1" <?= (in_array('national_code', $customer->matched_fields)) ? 'checked' : '' ?>>
                                            شماره همراه با کد ملی مطابقت دارد.
                                        </label>
                                    </div>
                                    <div class="form-group m-b-10">
                                        <label>
                                            <input type="checkbox" name="birth_date_matched" value="1" <?= (in_array('birth_date', $customer->matched_fields)) ? 'checked' : '' ?>>
                                            کد ملی با تاریخ تولد مطابقت دارد.
                                        </label>
                                    </div>
                                    <div class="form-group m-b-10">
                                        <label>
                                            <input type="checkbox" name="auth_call" value="1" <?= $customer->auth_call ? 'checked' : '' ?>>
                                            احراز هویت صوتی انجام شده است.
                                        </label>
                                    </div>
                                </div><!-- /.col -->
                            </div><!-- /.row -->
    
                        </div><!-- /.form-body -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
    </div><!-- /.col -->
    <div class="col-md-4">
        <div class="portlet box border shadow">
            <div class="portlet-heading">
                <div class="portlet-title">
                    <h3 class="title">
                        <i class="icon-picture"></i>
                        تصویر <span>(300x300)</span> پیکسل
                    </h3>
                </div><!-- /.portlet-title -->
                <div class="buttons-box">
                    <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                        <i class="icon-arrow-up"></i>
                    </a>
                </div><!-- /.buttons-box -->
            </div><!-- /.portlet-heading -->
            <div class="portlet-body">
                <div class="form-group box-image">
                    <?php
                    $class_hide = '';
                    if ($customer->image != '' && file_exists($customer->image)) {
                        $image = base_url() . $customer->image;
                        $class_hide = 'hide';
                    ?>
                        <div class="box-old-image">
                            <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/customers/removeImage/$customer->id"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                            <img class="img-responsive img-thumbnail" width="100" src="<?= $image ?>">
                        </div>
                    <?php
                    }
                    ?>
                    <div class="box-new-image <?= $class_hide ?>">
                        <input type="file" class="form-control ltr" name="image">
                    </div>
                </div>
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->

        <div class="portlet box border shadow bank-cards">
            <div class="portlet-heading">
                <div class="portlet-title">
                    <h3 class="title">
                        <i class="icon-credit-card"></i>
                        کارت‌های بانکی
                    </h3>
                </div><!-- /.portlet-title -->
                <div class="buttons-box">
                    <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                        <i class="icon-arrow-up"></i>
                    </a>
                </div><!-- /.buttons-box -->
            </div><!-- /.portlet-heading -->
            <div class="portlet-body">
                <div>
                    <span class="font-sm">کارت‌های بانکی که کاربر فقط با آن‌ها می‌تواند پرداخت آنلاین را انجام دهد.</p>
                </div>
                <div class="input-group curve">
                    <input type="text" class="form-control numeric ltr txt-card-number" maxlength="16" placeholder="شماره 16 رقمی کارت" autocomplete="off"> 
                    <span class="input-group-btn">
                        <button class="btn btn-primary btn-add" type="button">افزودن کارت<div class="paper-ripple"><div class="paper-ripple__background"></div><div class="paper-ripple__waves"></div></div></button>
                    </span>
                </div>
                <ul>
                    <?php if($bank_cards): ?>
                        <?php foreach ($bank_cards as $item): ?>
                            <li>
                                <input type="hidden" name="bank_cards[]"  value="<?= $item->card_number ?>">
                                <span class="btn-remove">حذف</span>
                                <span class="card-number"><?= bankCardFormat($item->card_number) ?></span>
                            </li>
                        <?php endforeach ?>
                    <?php endif ?>
                </ul>
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
    </div><!-- /.col -->
    <div class="col-md-12">
        <div class="portlet box border shadow">
            <div class="portlet-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-actions">
                            <a href="javascript: void(0)" class="btn btn-info btn-round" onclick="insert('<?php echo base_url('admin/customers/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url('admin/customers') ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
    </div><!-- /.col-md-12 -->
</form>

<script>
    $(document).ready(function(){
        // Date picker for birth date
        if($("#txt-birth-date").length){
            let value = $("#txt-birth-date").val();
            var datepicker = $("#txt-birth-date").pDatepicker({
                viewMode: 'year',
                format: "YYYY/MM/DD",
                observer: true,
                autoClose: true,
                toolbox: {
                    calendarSwitch: {
                        enabled: false
                    },
                },
                calendar:{
                    persian: {
                        leapYearMode: 'astronomical'
                    }
                }
            });
            if(value == ''){
                $("#txt-birth-date").val("");
            }
        }

        $(".bank-cards .btn-add").on("click", function(){
            let cardNumber = $(".bank-cards .txt-card-number").val();
            if(cardNumber.length == 0){
                swal('', 'شماره کارت را وارد کنید.', 'error');
                return;
            }

            cardNumber = cardNumber.replace(/[^0-9]/g, '');
            if(cardNumber.length != 16){
                swal('', 'شماره کارت صحیح نیست.', 'error');
                return;
            }

            let cardNumberFormated = cardNumber.replace(/\B(?=(\d{4})+(?!\d))/g, "-");
            
            $(".bank-cards .txt-card-number").val('');


            $(".bank-cards ul").append(`
                <li>
                    <input type="hidden" name="bank_cards[]"  value="${cardNumber}">
                    <span class="btn-remove">حذف</span>
                    <span class="card-number">${cardNumberFormated}</span>
                </li>
            `);
        });

        $(".bank-cards").on("click", ".btn-remove", function(){
            $(this).closest("li").remove();
        });
    });
</script>