<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-present"></i>
                    کوپن تخفیف
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">
                    <?php if (in_array('coupons_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/coupons/edit') ?>"  class="btn btn-primary btn-round btn-icon has-tooltip" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('coupons_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/coupons/publish'); ?>', '#frm-main', '<?php echo base_url('admin/coupons/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="انتشار">
                            <i class="icon-eye"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/coupons/un_publish'); ?>', '#frm-main', '<?php echo base_url('admin/coupons/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم انتشار">
                            <i class="icon-eye"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('coupons_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?php echo base_url('admin/coupons/delete'); ?>', '#frm-main', '<?php echo base_url('/admin/coupons/view'); ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- /.col -->
            </div><!-- /.row -->
            <br>
            <div>
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids">
                </form>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped " id="coupon-table">
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th>عنوان</th>
                            <th>کد</th>
                            <th>مقدار تخفیف</th>
                            <th>تعداد</th>
                            <th class="width-10">تعداد استفاده شده</th>
                            <th>شروع</th>
                            <th>پایان</th>
                            <th style="width:120px;">عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function() {
        var selectedMain = [];
        var tableMain = $('#coupon-table').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "couponLength": 25,
           "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false , "class": "width-10"},
                {"data": "title"},
                {"data": "code"},
                {"data": "amount"},
                {"data": "count"},
                {"data": "number_used"},
                {"data": "start_date"},
                {"data": "end_date"},
                {"data": "actions", "orderable": false}
            ],
            "ajax": {
                "url": "<?php echo base_url('admin/coupons/ajax_list') ?>",
                "type": "POST",
                data: function(d) {
                    d.<?= $this->security->get_csrf_token_name() ?> = $("input[name='" + csrfTokenName + "']").val();
                },
                dataSrc: function(json) {
                    if (json.csrf !== undefined)
                        $("input[name='" + csrfTokenName + "']").val(json.csrf);
                    return json.data;
                },
                "complete": function() {
                    $(".has-tooltip").tooltip();
                    window.Modiran.initiCkeck();
                    chackAllStatus($('#coupon-table'));
                }
            },
            "rowCallback": function(row, data) {
               if ($.inArray(data.id, selectedMain) !== -1) {
                   $(row).addClass('selected');
                   $(row).find("input").attr('checked', true);
               }
           },
            "sPaginationType": "full_numbers",
            "order": [], //Initial no order.

        });


        // Resize event
        $(window).on('resize', function() {
            $('#coupon-table').css("width", "100%");
        });

        // Select checkboxes
        $('#coupon-table tbody').on('ifChanged', 'input', function (event) {

            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#coupon-table'));
        });


    });
</script>
