<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-call-in fa-flip-horizontal"></i>
                    مدیریت تماس با ما
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">
                    <p class="text-right">
                        <?php if (in_array('contact_categories', $user_permissions)) : ?>
                            <a href="<?= base_url('admin/categories/index/contact') ?>" class="btn btn-primary btn-round" >
                                <i class="icon-organization"></i>
                                موضوعات
                            </a>
                        <?php endif; ?>
                        <?php if (in_array('contacts_edit', $user_permissions)) : ?>
                            <a href="javascript:void(0);" onclick="insert('<?php echo base_url('/admin/contacts/read/null/yes'); ?>', '#frm-main', '<?php echo base_url('/admin/contacts/view'); ?>', '#res', '#msg', false, true, 'noty', 'post')" class="btn btn-primary btn-icon btn-round action has-tooltip" title="خوانده شده">
                                <i class="icon-envelope-letter"></i>
                            </a>
                            <a href="javascript:void(0);" onclick="insert('<?php echo base_url('/admin/contacts/read/null/no'); ?>', '#frm-main', '<?php echo base_url('/admin/contacts/view'); ?>', '#res', '#msg', false, true, 'noty', 'post')" class="btn btn-warning action btn-icon btn-round has-tooltip" title="خوانده نشده">
                                <i class="icon-envelope"></i>
                            </a>
                        <?php endif; ?>
                        <?php if (in_array('contacts_delete', $user_permissions)) : ?>
                            <a href="javascript:void(0);"  onclick="deleteRow('<?php echo base_url('/admin/contacts/delete'); ?>', '#frm-main', '<?php echo base_url('/admin/contacts/view'); ?>', '#res', 'delete', 'post')" class="btn btn-danger action btn-icon btn-round has-tooltip" title="حذف">
                                <i class="fa fa-trash-o"></i>
                            </a>
                        <?php endif; ?>
                    <p>
                </div>
            </div>

            <br>
            <div>
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids">
                </form>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-condensed table-hover table-striped" id="data-table">
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th>ایمیل</th>
                            <th>شماره تماس</th>
                            <th>موضوع</th>
                            <th>زمان</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->



<script>
    $(document).ready(function () {
        var selectedMain = [];
        var tableMain = $('#data-table').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false , "class": "width-10"},
                {"data": "email"},
                {"data": "cell_phone"},
                {"data": "subject"},
                {"data": "jalali_created"},
                {"data": "actions", "orderable": false}
            ],

            // Load data for the table's content from an Ajax source
            "ajax": {
                "url": "<?php echo base_url('admin/contacts/ajax_list') ?>",
                "type": "POST",
                data: function (d) {
                    d.<?= $this->security->get_csrf_token_name() ?> = $("input[name='" + csrfTokenName + "']").val();
                },
                dataSrc: function (json) {
                    if (json.csrf !== undefined)
                        $("input[name='" + csrfTokenName + "']").val(json.csrf);
                    return json.data;
                },
                "complete": function (settings, json) {
                    $(".has-tooltip").tooltip();
                    window.Modiran.initiCkeck();
                    chackAllStatus($('#data-table'));
                }
            },
            "rowCallback": function(row, data) {
               if ($.inArray(data.id, selectedMain) !== -1) {
                   $(row).addClass('selected');
                   $(row).find("input").attr('checked', true);
               }
            },
            "sDom": 'T<"clear">lfrtip',
            "sPaginationType": "full_numbers",
            "order": [] //Initial no order.

        });


          // Select checkboxes
        $('#data-table tbody').on('ifChanged', 'input', function (event) {

            var id = event.target.value;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#data-table'));
        });

    });
</script>
