<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');
?>

<div class="col-md-8 col-md-offset-2">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-bubble"></i>
                    مدیریت فرم تماس
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <?php
            if ($contact) {
                ?>
                <form id="form-data" role="form" method="POST">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" name="id" value="<?= $contact->id ?>">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label  class="control-label">نام کاربر</label>
                                    <div class="form-control">
                                        <?= html_escape($contact->name) ?>
                                    </div>
                                </div><!--/.form-group-->
                            </div>
                        </div><!-- /.row -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label  class="control-label">موضوع</label>
                                    <div class="form-control">
                                        <?= html_escape($contact->subject) ?>
                                    </div>
                                </div><!--/.form-group-->
                            </div>
                        </div><!-- /.row -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label  class="control-label">ایمیل</label>
                                    <div class="form-control" dir="ltr">
                                        <?= html_escape($contact->email) ?>
                                    </div>
                                </div><!--/.form-group-->
                            </div>
                        </div><!-- /.row -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label  class="control-label">شماره تماس</label>
                                    <div class="form-control" dir="ltr">
                                        <?= $contact->cell_phone ?>
                                    </div>
                                </div><!--/.form-group-->
                            </div>
                        </div><!-- /.row -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label  class="control-label">زمان</label>
                                    <div class="form-control" dir="ltr">
                                        <?= $contact->jalali_created ?>
                                    </div>
                                </div><!--/.form-group-->
                            </div>
                        </div><!-- /.row -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label  class="control-label">متن پیام </label>
                                    <div class="form-control" style="height: auto;">
                                        <?= nl2br(html_escape($contact->text)) ?>
                                    </div>
                                </div><!--/.form-group-->
                            </div>
                        </div><!-- /.row -->
                    </div><!-- /.form-body -->


                    <?php if (in_array('contacts_edit', $user_permissions)) : ?>
                        <div class="form-group">
                            <label> پاسخ(به صورت ایمیل برای کاربر ارسال میشود) </label>
                            <textarea type="text" rows="7" class="form-control rtl text-right" name="answer"><?= $contact->answer ?></textarea>
                        </div><!-- /.form-group -->
                        <div class="form-group">
                            <label>
                                <input type="checkbox" name="send_email" value="1">
                                پاسخ به ایمیل کاربر ارسال شود
                            </label>
                        </div><!--/.form-group-->
                    <?php else: ?>
                        <div class="form-group">
                            <label class="control-label">پاسخ </label>
                            <div class="form-control" style="height: auto; min-height: 40px;">
                                <?= nl2br($contact->answer) ?>
                            </div>
                        </div><!--/.form-group-->
                    <?php endif; ?>

                    <div class="form-actions m-t-20 <?= (in_array('contacts_edit', $user_permissions)) ? 'text-right' : 'text-left'; ?>">
                        <?php if (in_array('contacts_edit', $user_permissions)) : ?>
                            <a class="btn btn-info btn-round btn-save" onclick="insert('<?php echo base_url('admin/contacts/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')" >
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                        <?php endif ?>
                        <a href="<?= base_url('admin/contacts') ?>" class="btn btn-warning btn-round <?= (in_array('contacts_edit', $user_permissions)) ? 'pull-left' : ''; ?>">
                            <i class="icon-close"></i>
                            بازگشت
                        </a>
                    </div><!-- /.form-actions -->
                </form>


                <?php
            } else {
                ?>
                <p>این مورد وجود ندارد</p>
                <a href="<?= base_url('admin/contacts') ?>" class="btn btn-warning btn-round pull-left">
                    <i class="icon-close"></i>
                    بازگشت
                </a>

                <?php
            }
            ?>
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col -->
