<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<style>
    #data-table tfoot th input{
        max-width: 180px;
    }
    .dataTables_filter{
        display: none;
    }
</style>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-credit-card"></i>
                    کارت ها
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-8">
                    <?php if (in_array('cards_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/cards/edit') ?>" class="btn btn-primary btn-round btn-icon has-tooltip" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                        <a href="<?= base_url('admin/cards/insertBatch') ?>" class="btn btn-info btn-round btn-icon has-tooltip" title="افزودن دسته ای">
                            <i class="icon-rocket"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('cards_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/cards/publishStatus/on') ?>', '#frm-main', '<?= base_url('admin/cards/view') ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="انتشار">
                            <i class="icon-eye"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/cards/publishStatus/off') ?>', '#frm-main', '<?= base_url('admin/cards/view') ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم انتشار">
                            <i class="icon-eye"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('cards_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?= base_url('admin/cards/delete') ?>', '#frm-main', '<?= base_url('admin/cards/view') ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>
                        </a>
                    <?php endif; ?>
                    <?php if($this->session->userdata('access_to_cards')): ?>
                        <a href="<?= base_url('admin/cards/logout') ?>"  class="btn btn-danger has-tooltip btn-round btn-icon" title="خروج از کارت ها">
                            <i class="icon-power"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- /.col -->
                <div class="col-md-4">
                    <div class="form-body m-t-5">
                        <div class="input-group round">
                            <input type="text" value="<?= $code ?>" class="form-control ltr text-center txt-search" placeholder="کد کامل کارت">
                            <span class="input-group-btn">
                                <button class="btn btn-info btn-search" type="button">
                                    <i class="icon-magnifier"></i>
                                </button>
                            </span>
                        </div><!-- ./input-group -->
                    </div>
                </div><!-- /.col -->
            </div><!-- /.row -->
            <div class="m-t-10 m-b-10">
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids">
                </form>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="data-table">
                    <tfoot class="top-search">
                        <tr>
                            <th class="input-hide"></th>
                            <th class="input-hide"></th>
                            <th class="input-hide"></th>
                            <th></th>
                            <th></th>
                            <th class="input-hide"></th>
                            <th class="select status"></th>
                            <th class="input-hide" style="min-width:140px"></th>
                        </tr>
                    </tfoot>
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th>کد اول کارت</th>
                            <th>نوع محصول</th>
                            <th>دسته</th>
                            <th>قفل؟</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function () {
        $(".btn-search").click(function () {
            var val = $(".txt-search").val().trim();
            if (val.length == 0) {
                window.location.href = baseUrl + "admin/cards";
            } else {
                window.location.href = baseUrl + "admin/cards/index/" + val;
            }
        });
        var selectedMain = [];

        $('#data-table tfoot th.status').each(function () {
            $(this).html('<select class="form-control"><option value="">هر دو</option><option value="1">فروخته شده</option><option value="0">قابل فروش</option></select>');
        });
        $('#data-table tfoot th:not(".select")').each(function () {
            var title = $('#data-table thead th').eq($(this).index()).text();
            $(this).html('<input type="text" class="form-control" style="width:100%" placeholder="' + title + '" />');
        });
        $('#data-table tfoot th.input-hide input').hide();

        var tableMain = $('#data-table').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "pageLength": 25,

            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false , "class": "width-10"},
                {"data": "code"},
                {"data": "product_title"},
                {"data": "category_title"},
                {"data": "deactive_status"},
                {"data": "sold"},
                {"data": "actions", "orderable": false}
            ],
            "ajax": {
                "url": "<?php echo base_url("admin/cards/ajax_list/$code") ?>",
                "type": "POST",
                data: function (d) {
                    d.<?= $this->security->get_csrf_token_name() ?> = $("input[name='" + csrfTokenName + "']").val();
                },
                dataSrc: function (json) {
                    if (json.csrf !== undefined)
                        $("input[name='" + csrfTokenName + "']").val(json.csrf);
                    return json.data;
                },
                "complete": function (settings, json) {
                    $(".has-tooltip").tooltip();
                    window.Modiran.initiCkeck();
                    chackAllStatus($('#data-table'));
                }

            },

            "sPaginationType": "full_numbers",
            "order": [], //Initial no order.
            "rowCallback": function(row, data) {
                if ($.inArray(data.id, selectedMain) !== -1) {
                    $(row).addClass('selected');
                    $(row).find("input").attr('checked', true);
                }
            },
        });


        // Select checkboxes
        $('#data-table tbody').on('ifChanged', 'input', function (event) {

            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#data-table'));
        });

        // Restore state
        var state = tableMain.state.loaded();
        if (state) {
            tableMain.columns().eq(0).each(function (colIdx) {
                var colSearch = state.columns[colIdx].search;
                if (colSearch.search) {
                    $('input', tableMain.column(colIdx).footer()).val(colSearch.search);
                }
            });
        }

       // Apply the search
        tableMain.columns().eq(0).each(function(colIdx) {
            $('input,select', tableMain.column(colIdx).footer()).on('keyup change', function() {
                tableMain
                        .column(colIdx)
                        .search($(this).val())
                        .draw();
            });
        });

        // Resize event handler
        $(window).on('resize', function () {
            $('#data-table').css("width", "100%");
        });

    });
</script>
