<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-plus"></i> افزودن دسته ای کارت
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <?php
                if ($this->session->flashdata('success')) {
                    ?>
                    <div class="col-md-12 m-b-20">
                        <div class=" alert alert-info"><?php echo $this->session->flashdata('success'); ?></div>
                    </div>
                    <?php
                }

                if ($this->session->flashdata('error')) {
                    ?>
                    <div class="col-md-12 m-b-20">
                        <div class=" alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
                    </div>
                    <?php
                }
                ?>

                <div class="col-md-12 p-b-30">
                    <?php
                    if (count($products)) {
                        ?>
                        <p>
                            <strong> توجه: </strong>
                            برای افزودن دسته ای کارت ها کدهای کارت ها بایدبا  کاما(,)جدا شده باشد
                            <button type="button" class="btn btn-info btn-round" data-toggle="modal" data-target="#myModal">نمونه فایل CSV</button>
                        </p>
                        <form id="form-data" role="form" method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">

                            <div class="form-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>انتخاب دسته محصول <span class="text-danger">*</span></label>
                                            <select  class="form-control select2" id="category_id" name="category_id" data-placeholder="انتخاب دسته">
                                                <option value=""></option>
                                                <?php
                                                if ($categories) {
                                                    foreach ($categories as $category) {
                                                        ?>
                                                        <option value="<?= $category->id ?>"><?= $category->title_fa ?></option>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>محصول <span class="text-danger">*</span></label>
                                            <select  class="form-control select2" name="product_id"></select>
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>وضعیت انتشار</label>
                                            <select  class="form-control" name="publish" >
                                                <option value="1" >انتشار</option>
                                                <option value="0">عدم انتشار</option>
                                            </select>
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>انتخاب فایل CSV</label>
                                            <input class="form-control" type="file" name="file">
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->

                                </div><!-- /.row -->
                            </div><!-- /.form-body -->
                            <div class="form-actions">
                                <a class="btn btn-info btn-round btn-save">
                                    <i class="icon-check"></i>
                                    افزودن دسته ای از روی فایل
                                </a>
                                <a href="<?= base_url('admin/cards') ?>" class="btn btn-warning btn-round pull-left">
                                    <i class="icon-close"></i>
                                    بازگشت
                                </a>
                            </div><!-- /.form-actions -->
                        </form>
                        <?php
                    }else {
                        ?>
                        <div class="alert alert-info b-t-20">
                            تا کنون هیچ محصولی ثبت نشده است، بنابراین امکان تعریف کارت وجود ندارد. برای تعریف محصول از دکمه زیر استفاده کنید.
                        </div>
                        <a class="btn btn-info btn-round" href="<?= base_url() . 'admin/products/edit/' ?>">افزودن محصول</a>
                        <?php
                    }
                    ?>

                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">نمونه فایل CSV</h4>
            </div>
            <div class="modal-body">
                <div>
                    <ol>
                        <li>
                            <a href="<?=base_url('assets/admin/files/csv/1.csv')?>"> <i class="icon-cloud-download"></i> <span>دانلود نمونه فایل تک رمزی</span></a>
                        </li>
                        <li>
                            <a href="<?=base_url('assets/admin/files/csv/2.csv')?>"> <i class="icon-cloud-download"></i> <span>دانلود نمونه فایل دو رمزی</span></a>
                        </li>
                        <li>
                            <a href="<?=base_url('assets/admin/files/csv/3.csv')?>"> <i class="icon-cloud-download"></i> <span>دانلود نمونه فایل سه رمزی</span></a>
                        </li>
                    </ol>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-round" data-dismiss="modal"><i class="icon-close"></i> بستن</button>
            </div>
        </div>

    </div>
</div>

<script>
$(document).ready(function () {
    $(".select2").select2({rtl: true});

    $("#category_id").change(function () {
        var id = this.value;

        $.ajax({
            url: "<?php echo base_url('admin/cards/getProducts/'); ?>" + id,
            type: "GET",
            success: function (data) {
                $("select[name='product_id']").html(data);
            },

        });
    });


    $(".btn-save").click(function (e) {
        e.preventDefault();
        insert('<?php echo base_url('admin/cards/saveBatch'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert');
    });
});
</script>
