<?php

if (!defined('BASEPATH'))
exit('No direct script access allowed');

class Tickets_m extends MY_Model {

    public $_table_name = 'tickets';
    public $_order_by = 'id asc';
    public $_primary_key = 'id';
    public $_timestamps = true;
    public $_filter = array();

    //list ajax start
    public $_table_ajax = 'tickets_view';
    var $column_order = array('id', null, 'title', 'full_name' , 'username' , 'category_title', 'priority', 'unread_admin', 'status', 'updated', null); //set column field database for datatable orderable
    var $column_search = array('full_name' , 'title'); //set column field database for datatable searchable
    var $columns_search = array('username'); //set column field database for datatable searchable
    var $filter = array(); // default filter
    var $order = array('updated' => 'desc'); // default order
    //list ajax end

    public function getNew() {
        $ticket = new stdClass();
        $ticket->id = 0;
        $ticket->category_id = 0;
        $ticket->user_id = 0;
        $ticket->title = '';
        $ticket->priority = '';
        $ticket->status = '';
        $ticket->cell_phone = '';
        return $ticket;
    }

    public function getDetail($ticket_id){
        $prefix = $this->db->dbprefix;
        $this->db->select('tickets.*');
        $this->db->select('users.first_name AS user_first_name, users.last_name AS user_last_name, users.image AS user_image, users.type AS user_type, users.username AS user_username, users.status AS user_status');
        $this->db->from('tickets');
        $this->db->join('users', "tickets.user_id = users.id AND tickets.id = '$ticket_id'");
        $query = $this->db->get();
        return $query->row();
    }

    public function getMessages($ticket_id){
        $this->db->select('messages.*');
        $this->db->select('users.first_name AS user_first_name, users.last_name AS user_last_name, users.image AS user_image, users.type AS user_type, users.username AS user_username');
        $this->db->from('messages');
        $this->db->join('users', "messages.user_id = users.id AND messages.ticket_id = '$ticket_id'");
        $this->db->order_by('created ASC');
        $query = $this->db->get();
        return $query->result();
    }

    //لیست تیکت های یک کاربر
    function getUserTickets($user_id, $offset, $limit, $get_count = false){
        $prefix = $this->db->dbprefix;

        if($get_count){
            $this->db->select("COUNT({$prefix}tickets.id) AS number");
        }else{
            $this->db->select('tickets.id, tickets.title, tickets.unread_user, tickets.status');
            $this->db->select('categories.title_fa AS category_title');
            $this->db->select("IF(last_messages.user_id = {$prefix}tickets.user_id, 'customer', 'admin') AS last_sender");
            $this->db->select("last_messages.created");
        }

        $this->db->from('tickets');
        $this->db->join('categories', "tickets.category_id = categories.id AND tickets.user_id = '$user_id'");
        
        if($get_count){
            return $this->db->get()->row()->number;
        }

        $this->db->join('messages AS last_messages', "tickets.last_message_id = last_messages.id");
        $this->db->limit($limit, $offset);
        $this->db->order_by('last_messages.created DESC');

        return $this->db->get()->result();
        
    }

    // تعداد پیام های خوانده نشده در یک تیکت و آیدی آخرین پیام را بروز می کند 
    public function updateUnreadAndLastMessage($id, $user_type){
        $prefix = $this->db->dbprefix;

        // به دست آوردن تعداد پیام های خوانده نشده با توجه به نوع کاربر
        $this->db->select("COUNT({$prefix}messages.id) AS number");
        $this->db->from('messages');
        $this->db->join('users', "
            messages.user_id = users.id AND 
            messages.ticket_id = $id AND 
            users.type <> '$user_type' AND 
            messages.reading = 0
        ");

        $number_of_unread = $this->db->get()->row()->number;
        if(!$number_of_unread){
            $number_of_unread = 0;
        }
        $field = ($user_type == 'customer') ? 'unread_user' : 'unread_admin';

        // به دست آوردن آخرین پیام
        $this->db->select("MAX({$prefix}messages.id) AS id");
        $this->db->from('messages');
        $this->db->where('ticket_id', $id);
        $last_message_id = $this->db->get()->row()->id;
        $last_message_id = ($last_message_id) ? $last_message_id * 1 : 0;

        // Update
        $this->db->set($field, $number_of_unread); // تعداد پیام های خوانده نشده
        $this->db->set('last_message_id', $last_message_id); // آیدی آخرین پیام
        $this->db->where('id', $id);
        $this->db->update('tickets');

        return (object)[
            'last_message_id' => $last_message_id,
            'number_of_unread' => $number_of_unread,
        ];
    }

    // تعداد پیام های که ادمین مشاهده نکرده
    public function getUnreadMessagesByAdmin(){
        $prefix = $this->db->dbprefix;
        $this->db->select("SUM({$prefix}tickets.unread_admin) AS number_of_tickets");
        $this->db->from('tickets');
        $this->db->join('users', "tickets.user_id = users.id AND users.deleted = 0 AND tickets.unread_admin > 0");

        $number = $this->db->get()->row()->number_of_tickets;
        return ($number) ? $number : 0;
    }

    // تعداد پیام های که کاربر مشاهده نکرده
    public function getUnreadMessagesByUser($user_id){
        $prefix = $this->db->dbprefix;
        $this->db->select("SUM({$prefix}tickets.unread_user) AS number_of_tickets");
        $this->db->from('tickets');
        $this->db->where('tickets.unread_user >', 0); 
        $this->db->where('tickets.user_id', $user_id);

        $number = $this->db->get()->row()->number_of_tickets;
        return ($number) ? $number : 0;
    }
    
}
