<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sliders_m extends MY_Model {

    public $_table_name = 'sliders';
    public $_order_by = 'ordering ASC';
    public $_primary_key = 'id';
    public $_timestamps = true;
    public $_filter=array();
  
    
    public function getNew() {
        $slider = new stdClass();
        $slider->id = '0';
        $slider->ordering = '';
        $slider->publish = 1;
        $slider->title = '';
        $slider->second_title = '';
        $slider->btn_title = '';
        $slider->image = '';
        $slider->image_xs = '';
        $slider->link = '';
        
        return $slider;
    }

    public function getForShow($is_mobile = false, $type = 'home_page', $item_id = 0){
        if($is_mobile){
            $this->db->select('image_xs AS image');
        } else {
            $this->db->select('image');
        }
        $this->db->select('link, title');
        $this->db->from('sliders');
        $this->db->join('slider_items', 'sliders.id = slider_items.slider_id');
        $this->db->where('sliders.publish', 1);
        $this->db->where('slider_items.type', $type);
        $this->db->where('slider_items.item_id', $item_id);
        $this->db->order_by('sliders.ordering ASC, sliders.id ASC');

        $items = $this->db->get()->result();

        $sliders = [];
        if($items){
            foreach ($items as $key => $item) {
                if($item->image && file_exists($item->image)){
                    $sliders[] = $item;
                } 
            }
        }
        unset($items);
        return $sliders;
    }
}