<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Notices_m extends MY_Model {

    public $_table_name = 'notices';
    public $_order_by = 'id DESC';
    public $_primary_key = 'id';
    public $_timestamps = true;

    //Begin notices list ajax
    public $_table_ajax = 'notices';
    var $column_order = array(null, null, 'title', 'start_time', 'end_time', null); //set column field database for datatable orderable
    var $column_search = array('title'); //set column field database for datatable searchable
    var $columns_search = array(); //set column field database for datatable searchable
    var $order = array('id' => 'DESC'); // default order
    var $filter = array(); // default filter
    //End notices list ajax


    public function getNew() {
        $item = new stdClass();

        $item->id = '0';
        $item->title = '';
        $item->content = '';
        $item->start_time = '';
        $item->end_time = '';
        $item->publish = '1';

        return $item;
    }

    public function getCurrentNotices(){
        $prefix = $this->db->dbprefix;

        $obj_result = (object)[
            'list' => [], // اطلاعیه‌های جاری
            'unseen_notice_ids' => [], // آیدی اطلاعیه‌های که دیده نشده‌اند
            'seen_notice_ids' => [], // آیدی اطلاعیه‌های دیده شده
            'db_seen_notice_ids' => [], // آیدی اطلاعیه‌های دیده شده در دیتابیس
        ];

        // delete_cookie('seen_notice_ids');
        // return $obj_result ;

        $now = date('Y-m-d H:i:s');
        $this->db->select("id, title, content");
        $this->db->from("notices");
        $this->db->where('start_time <=', $now);
        $this->db->where('end_time >=', $now);
        $this->db->where('publish', 1);
        $this->db->order_by('start_time');
        $notices = $this->db->get()->result();

        if(!$notices){
            delete_cookie('seen_notice_ids');
            return $obj_result;
        }

        $obj_result->list = $notices;
        

        // لیست آیدی اطلاعیه‌های موجود
        $notice_ids = array_map(function($item){
            return $item->id;
        }, $notices);

        // لیست دیده شده در دیتابیس
        $db_seen_notice_ids = [];
        if($this->user_login){
            $this->db->select("notice_id");
            $this->db->from("seen_notices");
            $this->db->where('user_id', $this->user_login->id);
            $this->db->where_in('notice_id', $notice_ids);
            $seen_notices = $this->db->get()->result();

            if($seen_notices){
                $db_seen_notice_ids = array_map(function($item){
                    return $item->notice_id;
                }, $seen_notices);
            }
        }
        $obj_result->db_seen_notice_ids = $db_seen_notice_ids;

        // لیست دیده شده‌ها در کوکی
        $cookie_seen_notice_ids = [];
        $current_cookie_notice_ids = get_cookie('seen_notice_ids');
        if($current_cookie_notice_ids){
            $current_cookie_notice_ids = explode(',', $current_cookie_notice_ids);
            $cookie_seen_notice_ids = array_intersect($notice_ids, $current_cookie_notice_ids);
        }

        // اجتماع دیده شده‌ها در دیتابیس و کوکی
        $seen_notice_ids = array_merge($db_seen_notice_ids, $cookie_seen_notice_ids);
        $seen_notice_ids = array_unique($seen_notice_ids);


        // Save in cookie
        if ($seen_notice_ids != $current_cookie_notice_ids) {
            $value = implode(',', $seen_notice_ids);
            set_cookie('seen_notice_ids', $value, 3600 * 24 * 30);
        }

        // Save in db
        if($this->user_login && $seen_notice_ids != $db_seen_notice_ids){
            $ids = array_diff($seen_notice_ids, $db_seen_notice_ids);
            $now = date('Y-m-d H:i:s');
            $data = [];
            foreach ($ids as $notice_id) {
                $data[] = [
                    'notice_id' => $notice_id,
                    'user_id' => $this->user_login->id,
                    'created' => $now,
                ];
            }

            $this->load->model('seen_notices_m');
            $this->seen_notices_m->insert_batch($data);
        }

        $obj_result->seen_notice_ids = $seen_notice_ids;


        // دیده نشده‌ها
        $obj_result->unseen_notice_ids = array_diff($notice_ids, $seen_notice_ids);

        // TEST
        // $obj_result->unseen_notice_ids = [];

        return $obj_result;
    }
}
