<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Failed_attempts_m extends MY_Model {

    public $_table_name = 'failed_attempts';
    public $_order_by = 'id DESC';
    public $_primary_key = 'id';
    public $_timestamps = true;

    // با این تابع مشخص می‌کنیم که کارب اجازه درخواست دادن را دارد یا خیر
    public function allowAttempt($user_id){
        $this->db->select('COUNT(id) AS number');
        $this->db->from('failed_attempts');
        $this->db->where('user_id', $user_id);
        $this->db->where('method <>', 'auth_call');
        $this->db->where('created >=', date('Y-m-d H:i:s', strtotime('-6 hours')));
        $number_of_try = $this->db->get()->row()->number;
        if($number_of_try >= 3){
            return false;
        }
        return true;
    }

    public function allowAttemptForAuthCall($user_id){
        $this->db->select('COUNT(id) AS number');
        $this->db->from('failed_attempts');
        $this->db->where('user_id', $user_id);
        $this->db->where('method', 'auth_call');
        $this->db->where('created >=', date('Y-m-d H:i:s', strtotime('-10 minutes')));
        $number_of_try = $this->db->get()->row()->number;
        if($number_of_try >= 10){
            return false;
        }
        return true;
    }
}
