<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Categories_m extends MY_Model {

    public $_table_name = 'categories';
    public $_order_by = 'ordering ASC';
    public $_primary_key = 'id';
    public $_timestamps = false;
    public $_filter = array('deleted' => '0');

    public function getNew() {
        $cat = new stdClass();

        $cat->id = '0';
        $cat->type = ''; // خوانده شود GET باید از
        $cat->title_fa = '';
        $cat->title_en = '';
        $cat->description = '';
        $cat->slug = '';
        $cat->image = '';
        $cat->large_image = '';
        $cat->field1_title = '';
        $cat->field2_title = '';
        $cat->field3_title = '';
        $cat->ordering = '';
        $cat->publish = 1;
        $cat->deleted = 0;
        $cat->meta_title = '';
        $cat->meta_description = '';
        $cat->description = '';
        $cat->fields = '';

        return $cat;
    }

    //به دست آوردن دسته بندی ها به همراه تعداد محصولاتشان
    public function getCategories($check_has_product = false) {
        $prefix = $this->db->dbprefix;
        if($check_has_product){

            $now = $now = date('Y-m-d H:i:s');
            
            $this->db->select("DISTINCT {$prefix}categories.id", false);
            $this->db->from("cards");
            $this->db->join("products", "
                products.id = cards.product_id AND
                products.publish = 1 AND 
                products.is_exists = 1 AND 
                products.deleted = 0 AND 
                cards.sold = 0 AND 
                cards.deactive_date < '$now' AND
                cards.publish = 1
            ");
            $this->db->join('categories', "
                categories.id = products.category_id AND
                categories.type = 'product' AND
                categories.publish = 1 AND 
                categories.deleted = 0
            ");
            $sub_query = $this->db->get_compiled_select();
    
        }

        $this->db->select('categories.id, categories.title_fa, categories.title_en, categories.image, categories.large_image, categories.slug, categories.description, categories.fields');
        $this->db->select(($check_has_product) ? "IF(t_categories.id, 1, 0) AS has_product" : "0 AS has_product");
        $this->db->from("categories");
        if($check_has_product){
            $this->db->join("($sub_query) t_categories","categories.id = t_categories.id", 'left');
        }
        $this->db->where('categories.type', 'product');
        $this->db->where('categories.publish', '1');
        $this->db->where('categories.deleted', '0');
        $this->db->order_by('has_product DESC, categories.ordering ASC');

        $query = $this->db->get();
        return $query->result();
    }


    public function getDetail($id = 0, $slug = ''){
        $slug =  trim($slug);
        if($id == 0 && $slug == ''){
            return null;
        }

        $this->db->select('id, title_fa, title_en, image, large_image, slug, meta_title, meta_description, description');
        $this->db->from('categories');
        $this->db->where('deleted', 0);
        $this->db->where('publish', 1);
        $this->db->where('type', 'product');
       
        if($id){
            $this->db->where('id', $id);
        } else {
            $this->db->where('slug', $slug);
        }
        return $this->db->get()->row();

    }

}
