<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cards_m extends MY_Model {

    public $_table_name = 'cards';
    public $_order_by = 'id DESC';
    public $_primary_key = 'id';
    public $_timestamps = false;
    public $_filter = NULL;


    //Begin pages list ajax
    public $_table_ajax = 'cards_view';
    var $column_order = array(null, null,'code', 'product_title', 'category_title', 'deactive_status', 'sold', null); //set column field database for datatable orderable
    var $column_search = array('code', 'product_title', 'category_title', 'sold'); //set column field database for datatable searchable 
    var $columns_search = array('code', 'product_title', 'category_title', 'sold', 'deactive_status'); //set column field database for datatable searchable 
    var $order = array('sold'=>'ASC', 'id' => 'DESC'); // default order
    var $filter = array(); // default filter
    //End pages list ajax


    public function getNew() {
        $card = new stdClass();
        $card->id = 0;
        $card->product_id = 0;
        $card->code = '';
        $card->code2 = '';
        $card->code3 = '';
        $card->extra_code = '';
        $card->expire_date = '';
        $card->sold = 0;
        $card->publish = 1;
        $card->file = '';
        $card->information = '';

        return $card;
    }

    // آرایه ای از کارتها را می گیرد و اطلاعات آن را میدهد
    public function getCardsInfo($card_ids){
        $this->db->select('cards.id, cards.code, cards.code2, cards.code3, cards.product_id, products.title, cards.file, cards.information');
        $this->db->select('categories.id AS category_id, categories.title_fa AS category_title');
        $this->db->from('cards');
        $this->db->join('products', 'cards.product_id=products.id');
        $this->db->join('categories', 'products.category_id=categories.id');
        $this->db->where_in('cards.id', $card_ids);
        $query = $this->db->get();
        $cards =  $query->result();

        foreach($cards as $card){
            $card->code = card_decrypt($card->code);
            if($card->code2){
                $card->code2 = card_decrypt($card->code2);
            }
            if($card->code3){
                $card->code3 = card_decrypt($card->code3);
            }
        }
        return $cards;
    }

    // لیست کارت های یک کاربر
    public function getUserCards($user_id, $tracking_code, $offset, $limit, $get_count = true){
        $prefix = $this->db->dbprefix;

        if($get_count){
            $this->db->select("COUNT({$prefix}cards.id) AS number");
        }else{
            $this->db->select('cards.id, cards.code, cards.code2, cards.code3, cards.file, cards.information');
            $this->db->select('products.id AS product_id, products.title AS product_title, products.slug AS product_slug, products.image');
            $this->db->select('categories.title_fa AS category_title, categories.field1_title, categories.field2_title, categories.field3_title, categories.image AS category_image');
            $this->db->select('orders.tracking_code, orders.pending');
        }
        $this->db->from('orders');
        $this->db->join('order_cards', "orders.id = order_cards.order_id AND (orders.paid = 1 OR orders.card2card <> '') AND orders.user_id = '$user_id'");
        $this->db->join('cards', "order_cards.card_id = cards.id AND cards.sold = 1");
        $this->db->join('products', 'cards.product_id = products.id');
        $this->db->join('categories', 'products.category_id = categories.id');

        if($tracking_code){
            $this->db->where('orders.tracking_code', $tracking_code);
        }

        if(!$get_count){
            $this->db->limit($limit, $offset);
            $this->db->order_by('order_cards.id DESC');
        }
        
        $query = $this->db->get();

        if($get_count){
            return $query->row()->number;
        }else{
            $cards =  $query->result();
            foreach($cards as $card){
                $card->code = card_decrypt($card->code);
                if($card->code2){
                    $card->code2 = card_decrypt($card->code2);
                }
                if($card->code3){
                    $card->code3 = card_decrypt($card->code3);
                }
            }
            return $cards;
        }
        
    }

    // گرفتن اطلاعات یک کارت برای خریدار یا همان مشتری
    public function getDetailCard($card_id){
        $prefix = $this->db->dbprefix;
        $this->db->select('cards.file');
        // $this->db->select('cards.id, cards.code, cards.code2, cards.code3, cards.file');
        // $this->db->select('products.id AS product_id, products.title AS product_title, products.image');
        // $this->db->select('categories.title_fa AS category_title, categories.field1_title, categories.field2_title, categories.field3_title, categories.image AS category_image');
        $this->db->select('orders.tracking_code, orders.pending, orders.user_id');

        $this->db->from('cards');
        $this->db->join('order_cards', "cards.id = order_cards.card_id AND cards.id = '$card_id'");
        $this->db->join('orders', "order_cards.order_id = orders.id AND orders.paid = 1");
        // $this->db->join('products', 'cards.product_id = products.id');
        // $this->db->join('categories', 'products.category_id = categories.id');
        
        $query = $this->db->get();
        return $query->row();
    }
}
