<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class blocks_m extends MY_Model {

    public $_table_name = 'blocks';
    public $_order_by = 'id desc';
    public $_primary_key = 'id';
    public $_timestamps = true;

    // BEGIN block list ajax
    public $_table_ajax = 'blocks_view';
    var $column_order = array(null, 'username', 'email', 'source', 'ip' , 'created'); //set column field database for datatable orderable
    var $column_search  = array('username', 'email', 'amount'); //set column field database for datatable searchable
    var $columns_search = array('username', 'email', 'source', 'ip'); //set column field database for datatable searchable
    var $filter = array(); // default filter
    var $order = array('id' => 'DESC'); // default order
    // END block list ajax

    // کاربر اصلی بلاک می‌شود و لاگ آن ثبت می‌شود
    // کاربران مرتبط (بر اساس ایمیل در سفارش یا پروفایل) پیدا و بلاک می‌شوند
    // origin_user_id برای کاربران مرتبط مشخص می‌کند که چه کسی باعث بلاک شدن آنها شده
    // این فرآیند تا ۵ سطح ادامه دارد
    public function smartBlockUsers($user_id, $source, $email = null){
        $now = date('Y-m-d H:i:s');

        $main_user = $this->db
            ->select('id')
            ->from('users')
            ->where('type', 'customer')
            ->where('block', 0)
            ->where('id', $user_id)
            ->get()->row();
        
        if(!$main_user){
            return;
        }

        $user_ids = [$main_user->id];
        $level = 1;
        $max_level = 5;
        do {
            // اول از همه این کاربران را بلاک  می‌کنیم
            $this->db->where_in('id', $user_ids);
            $this->db->update('users', ['block' => 1]);

            // لاگش را ثبت می‌کنیم
            if($level == 1){
                $data =  [
                    'user_id' => $main_user->id,
                    'email' => $email,
                    'source'  => $source,
                    'ip' => $this->input->ip_address(),
                    'created' => $now,
                ];
                $this->db->set($data)->insert('blocks');
            } else {
                $batch_data = [];
                foreach ($user_ids as $user_id) {
                    $batch_data[] = [
                        'user_id' => $user_id,
                        'origin_user_id' => $main_user->id,
                        'source' => 'user',
                        'created' => $now,
                    ];
                }
                $this->db->insert_batch('blocks', $batch_data); 
            }

            $emails = [];

            // به دست آوردن تمام ایمیل‌‌های که این کاربران توی سفارش ثبت کرده‌اند
            $orders = $this->db
                ->select('email')
                ->from('orders')
                ->where('email <>', '')
                ->where_in('user_id', $user_ids)
                ->get()->result();
            
            if($orders){
                foreach ($orders as $order) {
                    $emails[] = $order->email;
                }
            }

            // به دست آوردن ایمیل های که این کاربران توی پروفایلشون ثبت کرده‌اند
            $users = $this->db
                ->select('email')
                ->from('users')
                ->where('email <>', '')
                ->where_in('id', $user_ids)
                ->where('type', 'customer')
                ->get()->result();
            
            if($users){
                foreach ($users as $user) {
                    $emails[] = $user->email;
                }
            }

            $emails = array_unique($emails);

            $user_ids = [];

            if($emails){
                // آیدی کاربرانی که از این ایمیل ها در سفارش استفاده کرده باشند
                // و هنوز بلاک نشده باشند
                $orders = $this->db
                    ->select('orders.user_id')
                    ->from('orders')
                    ->join('users', 'orders.user_id = users.id')
                    ->where_in('orders.email', $emails)
                    ->where('users.block', 0)
                    ->get()->result();
                
                if($orders){
                    foreach ($orders as $order) {
                        $user_ids[] = $order->user_id;
                    }
                }

                // آیدی کاربرانی که از این ایمیل ها در پروفایل استفاده کرده باشند
                // و هنوز بلاک نشده باشند
                $users = $this->db
                    ->select('id')
                    ->from('users')
                    ->where_in('email', $emails)
                    ->where('type', 'customer')
                    ->where('block', 0)
                    ->get()->result();
                
                if($users){
                    foreach ($users as $user) {
                        $user_ids[] = $user->id;
                    }
                }

                $user_ids = array_unique($user_ids);
            }
            

            $level++;
        } while ($user_ids && $level <= $max_level);
    }
    
    public function isEmailBlacklisted($email){
        if(empty($email)){
            return false;
        }

        // Get settings smart block
        $block_setting = $this->db
            ->select('value')
            ->from('settings')
            ->where('key', 'smart_block')
            ->get()->row();

        if(!$block_setting){
            return false;
        }

        $block_setting = json_decode($block_setting->value);

        if(!$block_setting->active || !$block_setting->blacklist_domains){
            return false;
        }

        // گرفتن دامین ایمیل
        $parts = explode('@', $email);
        if(count($parts) !== 2){
            return false; // ایمیل نامعتبر
        }

        $domain = strtolower($parts[1]);

        // بررسی اینکه آیا دامین در لیست بلاک شده‌ها هست
        $blacklist = array_map('strtolower', $block_setting->blacklist_domains);

        if(in_array($domain, $blacklist)){
            return true; // دامین غیرمجاز است
        }

        return false;

    }
}
