<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_slider_items_table extends CI_Migration
{

    public function up()
    {
        if (!$this->db->table_exists('slider_items')) {
            $this->dbforge->add_field([
                'id' => [
                    'type' => 'INT',
                    'constraint' => 11,
                    'unsigned' => TRUE,
                    'auto_increment' => TRUE
                ],
                'slider_id' => [
                    'type' => 'INT',
                    'constraint' => 11,
                ],
                'type' => [
                    'type' => 'VARCHAR',
                    'constraint' => 31,
                    'comment' => 'category, page, home_page, contact_us, faqs',
                ],
                'item_id' => [
                    'type' => 'INT',
                    'constraint' => 11,
                    'comment' => 'category_id, page_id',
                ],
                
            ]);
            $this->dbforge->add_key('id', TRUE);
            $this->dbforge->create_table('slider_items');
    
            $this->db->query("ALTER TABLE {$this->db->dbprefix}slider_items ADD INDEX(slider_id);");
        }
    }

    public function down()
    {
        $this->dbforge->drop_table('slider_items');
    }
}
