<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_failed_attempts_table extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'user_id' => [
                'type' => 'INT',
                'constraint' => 11,
            ],
            'method' => [
                'type' => 'VARCHAR',
                'constraint' => 32,
            ],
            'value' => [
                'type' => 'VARCHAR',
                'constraint' => 127,
            ],
            'created' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
            ],
        ]);
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('failed_attempts');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}failed_attempts ADD INDEX(user_id);");

    }

    public function down()
    {
        $this->dbforge->drop_table('failed_attempts');
    }
}
