<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_matched_fields_and_birth_date_and_father_name_to_users extends CI_Migration
{

    public function up()
    {
        
        if (!$this->db->field_exists('matched_fields', 'users')){
            $fields = [
                'matched_fields' => [
                    'type' => 'VARCHAR',
                    'constraint' => 63,
                    'after' => 'status',
                    'default' => '',
                    'comment' => 'فیلدهای که در استعلام تطابق داشته اند مثلا کد ملی یا تاریخ تولد',
                ],
            ];
            $this->dbforge->add_column('users', $fields);
        }

        if (!$this->db->field_exists('birth_date', 'users')){
            $fields = [
                'birth_date' => [
                    'type' => 'VARCHAR',
                    'constraint' => 10,
                    'after' => 'national_code',
                    'default' => '',
                ],
            ];
            $this->dbforge->add_column('users', $fields);
        }
        if (!$this->db->field_exists('father_name', 'users')){
            $fields = [
                'father_name' => [
                    'type' => 'VARCHAR',
                    'constraint' => 63,
                    'after' => 'last_name',
                    'default' => '',
                ],
            ];
            $this->dbforge->add_column('users', $fields);
        }
    }

    public function down()
    {
        if ($this->db->field_exists('matched_fields', 'users')){
            $this->dbforge->drop_column('users', 'matched_fields');
        }

        if ($this->db->field_exists('birth_date', 'users')){
            $this->dbforge->drop_column('users', 'birth_date');
        }

        if ($this->db->field_exists('father_name', 'users')){
            $this->dbforge->drop_column('users', 'father_name');
        }
    }
}
