<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_gifts_table extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'title' => array(
                'type' => 'VARCHAR',
                'constraint' => 63,
            ),
            'code' => array(
                'type' => 'VARCHAR',
                'constraint' => 63,
            ),
            'amount' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'count' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'start_date' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
            'end_date' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
            'publish' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
            ),
            'created' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('gifts');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}gifts ADD INDEX(code);");

    }

    public function down()
    {
        $this->dbforge->drop_table('gifts');
    }
}
