<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_tickets_view extends CI_Migration
{

    public function up()
    {
        $prefix = $this->db->dbprefix;
        $sql = "DROP VIEW IF EXISTS `{$prefix}tickets_view`";
        $this->db->query($sql);

        $sql = "
            CREATE VIEW {$prefix}tickets_view AS
            SELECT
                {$prefix}tickets.id,
                {$prefix}tickets.user_id,
                {$prefix}tickets.title,
                {$prefix}tickets.priority,
                {$prefix}tickets.unread_admin,
                {$prefix}tickets.unread_user,
                {$prefix}tickets.updated,
                {$prefix}tickets.created,
                {$prefix}tickets.category_id,
                {$prefix}categories.title_fa AS category_title,
                CONCAT({$prefix}users.first_name, ' ', {$prefix}users.last_name) AS full_name,
                {$prefix}users.username AS username,
                IF({$prefix}tickets.status = 'close', 'close', IF(last_messages.user_id = {$prefix}tickets.user_id, 'pending', 'done')) AS status
            FROM {$prefix}tickets 
            JOIN {$prefix}users ON {$prefix}tickets.user_id = {$prefix}users.id AND {$prefix}users.deleted = 0
            JOIN {$prefix}categories ON {$prefix}tickets.category_id = {$prefix}categories.id 
            JOIN {$prefix}messages AS last_messages ON {$prefix}tickets.last_message_id = last_messages.id;
        ";
        $this->db->query($sql);
    }

    public function down()
    {
        $sql = "DROP VIEW IF EXISTS  `{$this->db->dbprefix}tickets_view`";
        $this->db->query($sql);
    }
}
