<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_verifications extends CI_Migration
{

    public function up()
    {
       
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'cell_phone' => array(
                'type' => 'VARCHAR',
                'constraint' => 15,
            ),
            'code' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'used' => array(
                'type' => 'INT',
                'constraint' => 1,
            ),
            'created' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('verifications');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}verifications ADD INDEX(cell_phone);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}verifications ADD INDEX(code);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}verifications ADD INDEX(created);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}verifications ADD INDEX(used);");
    }

    public function down()
    {
        $this->dbforge->drop_table('verifications');
    }
}
