<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');
require( APPPATH . 'libraries/jibit/Jibit.class.php');

class Gateway
{
    private $apiKey;
    private $apiSecret;
    private $purchaseId;
    private $purchaseIdStr;
    private $pspSwitchingUrl;
    private $error;
    // private $pspRrn;
    private $paidAmount;
    private $detail;

    
    public function __construct($config) {
        $this->setApiKey($config['apiKey']);
        $this->setApiSecret($config['apiSecret']);
    }

    public function setApiKey($apiKey){
        $this->apiKey = $apiKey;
    }

    public function setApiSecret($apiSecret){
        $this->apiSecret = $apiSecret;
    }

    public function getError(){
        return $this->error;
    }

    public function getPurchaseId(){
        return $this->purchaseId;
    }

    public function getDetail(){
        return $this->detail;
    }

    public function getPaidAmount(){
        return $this->paidAmount;
    }
    
    // public function getPspRrn(){
    //     return $this->pspRrn;
    // }

    public function redirect()
	{
        header('Location: '.$this->pspSwitchingUrl);
        exit;
	}

    // $amount => مبلغ به ریال
    // $referenceNumber => transaction_id
    // $userIdentifier => اطلاعات کاربر مانند شماره همراه
	public function request($amount, $referenceNumber, $userIdentifier, $callbackUrl, $payerCardNumber = null)
	{
        try{
            $jibit = new Jibit($this->apiKey, $this->apiSecret);
            $requestResult = $jibit->paymentRequest($amount, $referenceNumber, $userIdentifier, $callbackUrl, $currency = 'IRR', $description = null, $additionalData = null, $payerCardNumber);
            // var_dump($requestResult);
            // die();

            if (
                !empty($requestResult['pspSwitchingUrl']) &&
                !empty($requestResult['purchaseId']) &&
                !empty($requestResult['purchaseIdStr']) &&
                !empty($requestResult['clientReferenceNumber']) &&
                $requestResult['clientReferenceNumber'] == $referenceNumber
            ) {
                //successful result and redirect to PG
                $this->purchaseId = $requestResult['purchaseId'];
                $this->purchaseIdStr = $requestResult['purchaseIdStr'];
                $this->pspSwitchingUrl = $requestResult['pspSwitchingUrl'];
                return true;
            } else if (!empty($requestResult['errors'])) {
                //fail result and show the error
                $this->error = $requestResult['errors'][0]['code'];
                if (!empty($requestResult['errors'])){
                    $this->error .= ', ' . $requestResult['errors'][0]['message'];
                }
            }

            return false;
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
	}

	public function verify($purchaseId)
	{   
        try{
            $jibit = new Jibit($this->apiKey, $this->apiSecret);
            $requestResult = $jibit->paymentVerify($purchaseId);
            // var_dump($requestResult);
            // die();

            if (!empty($requestResult['status']) && $requestResult['status'] === 'SUCCESSFUL') {
                //successful result
                // echo 'Successful! refNum:' . $purchaseId .PHP_EOL;
            
                //show session detail
                $order = $jibit->getOrderById($purchaseId);

                // $this->pspRrn = $order['pspRrn'];
                $this->paidAmount = isset($order['elements'][0]['amount']) ? $order['elements'][0]['amount'] : 0;
                $this->detail = json_encode($order);
                return true;
            }
        }catch (\Throwable $th) {
            // $th->getCode()
        }
        return false;
	}
}