<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Created for CodeIgniter by Rayanik
 * author: Rayanik
 * ID: @vanda
 * Date: 12/11/2022
 * Website: Rayanik.com
 * Email: info@rayanik.com
 * @copyright 2022
 * @package Vanda_Gateway
 * @version 1.0
 */

if (!class_exists('nusoap_client')) {
    require_once 'nusoap.php';
}

class Vanda
{
    private $ERR;

    public function request($api, $amount, $order_id, $call_back, $desc, $mobile = null, $email = null)
    {
        $data_string = json_encode(array(
            'pin'          => $api,
            'price'        => $amount,
            'callback'     => $call_back,
            'order_id'     => $order_id,
            "email"        => $email,
            'description'  => $desc,
            'name'         => '',
            'mobile'       => $mobile,
            'ip'           => $_SERVER['REMOTE_ADDR'],
            'callback_type'=> 2
        ));

        $ch = curl_init('https://www.vandapardakht.com/index.php/Request');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string))
        );
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 20);
        $result = curl_exec($ch);
        curl_close($ch);
        try{
            $json = json_decode($result,true);
            return $json;
        }catch(\Throwable $th){
            return false;
        }
    }

    public function redirect($form)
    {
        echo "<div style='display:none'>{$form}</div>Please wait ... <script language='javascript'>document.payment.submit(); </script>";
    }

    public function get_error()
    {
        switch ($this->ERR) {
            case '0':
                $error_message = 'پرداخت ناتمام یا ناموفق';
                break;
            case '-1':
                $error_message = 'پارامترهای ارسالی برای متد مورد نظر ناقص یا خالی هستند . پارمترهای اجباری باید ارسال گردد';
                break;
            case '-2':
                $error_message = 'دسترسی api برای شما مسدود است';
                break;
            case '-6':
                $error_message = 'عدم توانایی اتصال به گیت وی بانک از سمت وبسرویس';
                break;
            case '-9':
                $error_message = 'خطای ناشناخته';
                break;
            case '-20':
                $error_message = 'پین نامعتبر';
                break;
            case '-21':
                $error_message = 'ip نامعتبر';
                break;
            case '-22':
                $error_message = ' مبلغ وارد شده کمتر از حداقل مجاز میباشد ';
                break;
            case '-23':
                $error_message = ' مبلغ وارد شده بیشتر از حداکثر مبلغ مجاز هست';
                break;
            case '-24':
                $error_message = 'مبلغ وارد شده نامعتبر';
                break;
            case '-26':
                $error_message = 'درگاه غیرفعال است';
                break;
            case '-27':
                $error_message = 'آی پی مسدود شده است';
                break;
            case '-28':
                $error_message = 'آدرس کال بک نامعتبر است ، احتمال مغایرت با آدرس ثبت شده';
                break;
            case '-29':
                $error_message = 'آدرس کال بک خالی یا نامعتبر است';
                break;
            case '-30':
                $error_message = 'چنین تراکنشی یافت نشد';
                break;
            case '-31':
                $error_message = 'تراکنش ناموفق است';
                break;
            case '-32':
                $error_message = 'مغایرت مبالغ اعلام شده با مبلغ تراکنش';
                break;
            case '-35':
                $error_message = 'شناسه فاکتور اعلامی order_id نامعتبر است';
                break;
            case '-36':
                $error_message = 'پارامترهای برگشتی بانک bank_return نامعتبر است';
                break;
            case '-38':
                $error_message = ' تراکنش برای چندمین بار وریفای شده است';
                break;
            case '-39':
                $error_message = 'تراکنش در حال انجام است';
                break;
            case '-100':
                $error_message = 'خطا در مقدار و نوع پارامترهای ارسالی';
                break;
            default:
                $error_message = 'خطای ناشناس در اتصال به درگاه پذیرنده';
        }
        
        return $error_message;
    }

    public function verify($api, $amount, $order_id, $authority, $bank_return)
    {
        $data_string = json_encode(array (
            'pin'         => $api,
            'price'       => $amount,
            'order_id'    => $order_id,
            'au'          => $authority,
            'bank_return' => $bank_return
        ));

        $ch = curl_init('https://www.vandapardakht.com/index.php/verify');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string))
        );
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 20);
        $result = curl_exec($ch);
        curl_close($ch);
        try{
            $json = json_decode($result, true);

            if($json && isset($json['result'])){
                if($json['result']==1){

                    return $json;
                }else{
                    $this->ERR = $json['result'];
                    return false;
                }
            }
            return false;
        }catch(\Throwable $th){
            return false;
        }
    }
}