<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sitemap_lib {

    public function update() {
        $CI = & get_instance();
        $CI->load->model('pages_m');
        $CI->load->model('products_m');
        $CI->load->model('categories_m');
        $CI->load->helper('url');

        $content = '';
        $now = date('Y-m-d');

        //general
        $generals = [
            (object) ['priority' => '1', 'lastmod' => "", 'url' => ''],
            (object) ['priority' => '1', 'lastmod' => "", 'url' => 'home'],
            (object) ['priority' => '0.9', 'lastmod' => "", 'url' => 'faqs'],
            (object) ['priority' => '0.8', 'lastmod' => "", 'url' => 'contact-us'],
        ];
 
        foreach ($generals as $item) {
            if ($item->lastmod) {
                $content .='
    <url>
        <loc>' . base_url($item->url) . '</loc>
        <priority>' . $item->priority . '</priority>
        <lastmod>' . $item->lastmod . '</lastmod>
    </url>';
            } else {
                $content .='
    <url>
        <loc>' . base_url($item->url) . '</loc>
        <priority>' . $item->priority . '</priority>
    </url>';
            }
        }

        // Categories
        $categories = $CI->categories_m->get_by('id, slug', ['publish' => 1, 'deleted' => 0, 'type' => 'product']);
        if($categories){
            foreach ($categories as $item) {
                $url = ($item->slug) ? base_url("category/".urlencode($item->slug)) : base_url("category/$item->id");
                $content .='
    <url>
        <loc>'.$url.'</loc>
        <priority>0.9</priority>
    </url>';
            }
        }

        // Products
        $products = $CI->products_m->get_by('id, slug', ['publish' => 1, 'deleted' => 0]);
        if($products){
            foreach ($products as $item) {
                $url = ($item->slug) ? base_url("product/".urlencode($item->slug)) : base_url("product/$item->id");
                $content .='
    <url>
        <loc>'.$url.'</loc>
        <priority>0.8</priority>
    </url>';
            }
        }

        // Pages
        $pages = $CI->pages_m->get_by('id, slug, updated', ['publish' => 1]);
        if ($pages) {
            foreach ($pages as $item) {
                $url = base_url("page/$item->id-$item->slug");
                $lastmod = date('Y-m-d', strtotime($item->updated));
                $content .='
    <url>
        <loc>' . $url . '</loc>
        <priority>0.9</priority>
    </url>';
            }
        }
        
        
        $CI->load->helper('file');
        $data = '<?xml version="1.0" encoding="utf-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">';
        $data .= $content;
        $data .= '
</urlset>';
        //echo $data;
        

        if (!write_file('sitemap.xml', $data)) {
            return FALSE;
        } else {
            return TRUE;
        }
    }

   

}
