<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Sepal
{
    private $error;
    private $payment_number;
    private $url;
    private $card_number;
    private $sandbox = false;

    public function getError()
    {
        return $this->error;
    }

    public function getPaymentNumber()
    {
        return $this->payment_number;
    }

    public function getCardNumber()
    {
        return $this->card_number;
    }

	public function redirect()
	{
        header('Location: '.$this->url);
        exit;
	}

	public function request($apiKey, $amount, $callbackUrl, $invoiceNumber, $payerName = '', $payerMobile = '', $payerEmail = '', $description = '')
	{
        try{
            $request_url = 'https://sepal.ir/api/request.json';
            $redirect_url = 'https://sepal.ir/payment/';
            if($this->sandbox){
                $apiKey = 'test';
                $request_url = 'https://sepal.ir/api/sandbox/request.json';
                $redirect_url = 'https://sepal.ir/sandbox/payment/';
            }

            $params = array(
                'apiKey' => $apiKey,
                'amount' => $amount, // مبلغ به ریال
                'callbackUrl' => $callbackUrl,
                'invoiceNumber' =>  $invoiceNumber, // شماره فاکتور
                'payerName' => $payerName, // نام پرداخت کننده
                'payerMobile' => $payerMobile, // موبایل پرداخت کننده
                'payerEmail' => $payerEmail, // پست الکترونیکی پرداخت کننده
                'description' => $description, // توضیحات
            );
            
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $request_url);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($params));
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $response = json_decode(curl_exec($curl));
            curl_close($curl);

            if(isset($response->status) && $response->status == 1 ){
                $this->payment_number = $response->paymentNumber;
                $this->url = $redirect_url . $response->paymentNumber;
                return true;
            }else{
                $this->error = (isset($response->message)) ? $response->message : '';
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
	}

	public function verify($apiKey, $paymentNumber)
	{   
        try{
            $verify_url = 'https://sepal.ir/api/verify.json';
            if($this->sandbox){
                $apiKey = 'test';
                $verify_url = 'https://sepal.ir/api/sandbox/verify.json';
            }

            $params = array(
                'apiKey' => $apiKey,
                'paymentNumber' => $paymentNumber,
            );
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $verify_url);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode( $params ));
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $response = json_decode(curl_exec($curl));
            curl_close($curl);
            if(isset($response->status) && $response->status == 1){
                // تراکنش با موفقیت انجام شد;
                $this->card_number = isset($response->cardNumber) ? $response->cardNumber : '';
                return true;
            }else{
                $this->error = (isset($response->message)) ? $response->message : '';
                return false;
            }

        }catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
	}
}