<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

require( APPPATH . 'libraries/IPPanel/Client.php');
require( APPPATH . 'libraries/IPPanel/HTTPClient.php');
require( APPPATH . 'libraries/IPPanel/Models/Base.php');
require( APPPATH . 'libraries/IPPanel/Models/Response.php');
require( APPPATH . 'libraries/IPPanel/Models/InboxMessage.php');
require( APPPATH . 'libraries/IPPanel/Models/Message.php');
require( APPPATH . 'libraries/IPPanel/Models/Pattern.php');
require( APPPATH . 'libraries/IPPanel/Models/Recipient.php');
require( APPPATH . 'libraries/IPPanel/Errors/Error.php');
require( APPPATH . 'libraries/IPPanel/Errors/HttpException.php');
require( APPPATH . 'libraries/IPPanel/Errors/ResponseCodes.php');
class Rangine {
    private $err;

    public function send_by_token($api_key, $from, $to, $patternCode, $token1='', $token2='',$token3='') {
        $patternValues = ['token' => strval($token1)];
        if($token2)  $patternValues['token2'] = strval($token2);
        if($token3)  $patternValues['token3'] = strval($token3);
        
        // $time = date('Y-m-d H:i:s');
        // $json_pattern_values = json_encode($patternValues, JSON_UNESCAPED_UNICODE);
        // $text = "time:$time, to:$to, patternCode:$patternCode, json_pattern_values:$json_pattern_values \n";
        // writeFile($text, 'sms');
        // return true;

        try {
            $client = new \IPPanel\Client($api_key);
            $result = $client->sendPattern($patternCode, $from, $to, $patternValues);
            if (intval($result)) {
                return $result;
            } else {
                $this->err = $result;
                return false;
            }
        } catch (\Throwable $th) {
            $this->err = 'کد خطا: ' . $th->getCode();
            return false;
        }
    }

    public function send($api_key, $from, $to, $message) {
        $to = [$to];
        
        // $time = date('Y-m-d H:i:s');
        // $json_to = json_encode($to);
        // $text = "time:$time, to:$json_to, message:$message \n";
        // writeFile($text, 'sms');
        // return true;

        try {
            $client = new \IPPanel\Client($api_key);
            $result = $client->send($from, $to, $message);
            if (intval($result)) {
                return $result;
            } else {
                $this->err = $result;
                return false;
            }
        } catch (\Throwable $th) {
            $this->err = 'کد خطا: ' . $th->getCode();
            return false;
        }
    }

    public function get_error()
    {
        return strval($this->err);
    }
}
