<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
 * CodeIgniter pay.ir getway library
 *
 * @author              mohammad delavari kashkoli
 * @license             GNU Public License 1.0
 * @package             pay.ir
 */

class Payir {

    private $authority;
    private $errorCode;
    private $errorMessage;
    private $url;
    private $paid_amount;
    
    function send($api, $amount, $redirect, $factorNumber = null) {
        try{
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://pay.ir/payment/send');
            curl_setopt($ch, CURLOPT_POSTFIELDS, "api=$api&amount=$amount&redirect=$redirect&factorNumber=$factorNumber");
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            curl_close($ch);
            
            
            $result=  json_decode($result);
            
            if ($result->status == 1) {
                $this->authority = $result->transId;
                $this->url = "https://pay.ir/payment/gateway/".$result->transId;
                
                return true;
            } else {
                $this->errorCode = $result->errorCode;
                $this->errorMessage = $result->errorMessage;

                return false;
            }
        } catch (\Throwable $th) {
            $this->errorCode = $th->getCode();
            return false;
        }
    }

    function verify($api, $transId) {
        try{
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://pay.ir/payment/verify');
            curl_setopt($ch, CURLOPT_POSTFIELDS, "api=$api&transId=$transId");
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            curl_close($ch);
            
            $result=  json_decode($result);
            if ($result->status == 1) {
                $this->paid_amount = $result->amount;
                
                return true;
            } else {
                $this->errorCode = $result->errorCode;
                $this->errorMessage = $result->errorMessage;

                return false;
            }
        } catch (\Throwable $th) {
            $this->errorCode = $th->getCode();
            return false;
        }
    }
    
    public function get_authority()
    {
        return $this->authority;
    }
    
    public function redirect()
    {
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }
        redirect($this->url);
    }
    
    public function get_error()
    {
        return $this->errorMessage;
    }
    
    public function get_paid_amount()
    {
        return $this->paid_amount;
    }


}
