<?php
/**
 * @author Rayanik.com
 * NextPay.IR PHP 
 * Docs : https://nextpay.org/nx/docs
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Nextpay
{
    private $error;
    private $trans_id;
    private $ref_id;
    private $paid_amount;
    private $order_id;

    public function get_error()
    {
        return $this->error;
    }

    public function get_trans_id()
    {
        return $this->trans_id;
    }

    public function get_ref_id()
    {
        return $this->ref_id;
    }

    public function get_paid_amount()
    {
        return $this->paid_amount;
    }
    
    public function get_order_id()
    {
        return $this->order_id;
    }

	public function redirect()
	{
        header('Location: https://nextpay.org/nx/gateway/payment/'.$this->trans_id);
        exit;
	}

	public function request($api_key, $amount, $callback_uri, $order_id, $customer_phone = '')
	{
        try{
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://nextpay.org/nx/gateway/token',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => "api_key=$api_key&amount=$amount&order_id=$order_id&customer_phone=$customer_phone&callback_uri=$callback_uri",
            ));

            $res = json_decode(curl_exec($curl));
            curl_close($curl);
            if ($res != "" && $res != NULL && is_object($res)) {
                if (intval($res->code) == -1){
                    $this->trans_id = $res->trans_id;
                    return true;
                } else {
                    $this->error = $this->code_error($res->code);
                    return false;
                }
            } else {
                return false;
            }
          
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
	}

	public function verify($api_key, $amount, $trans_id)
	{   
        try{
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://nextpay.org/nx/gateway/verify',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => "api_key=$api_key&amount=$amount&trans_id=$trans_id",
            ));

            $res = json_decode(curl_exec ($curl));
            curl_close ($curl);

            if ($res != "" && $res != NULL && is_object($res)) {
                if($res->code == 0 ){
                    $this->paid_amount = $res->amount;
                    $this->ref_id = $res->Shaparak_Ref_Id;
                    $this->order_id = $res->order_id;
                    return true;
                } else {
                    $this->error = $this->code_error($res->code);
                    return false;
                }
            } else {
                return false;
            }
        }catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
	}

    public function code_error($error_code)
    {
        $error_code = intval($error_code);
        $error_array = array(
            0   => "پرداخت تکمیل و با موفقیت انجام شده است",
            -1  => "منتظر ارسال تراکنش و ادامه پرداخت",
            -2  => "پرداخت رد شده توسط کاربر یا بانک",
            -3  => "پرداخت در حال انتظار جواب بانک",
            -4  => "پرداخت لغو شده است",
            -20 => "کد api_key ارسال نشده است",
            -21 => "کد trans_id ارسال نشده است",
            -22 => "مبلغ ارسال نشده",
            -23 => "لینک ارسال نشده",
            -24 => "مبلغ صحیح نیست",
            -25 => "تراکنش قبلا انجام و قابل ارسال نیست",
            -26 => "مقدار توکن ارسال نشده است",
            -27 => "شماره سفارش صحیح نیست",
            -28 => "مقدار فیلد سفارشی custom_json_fields از نوع json نیست",
            -29 => "کد بازگشت مبلغ صحیح نیست",
            -30 => "مبلغ کمتر از حداقل پرداختی است",
            -31 => "صندوق کاربری موجود نیست",
            -32 => "مسیر بازگشت صحیح نیست",
            -33 => "کلید مجوز دهی صحیح نیست",
            -34 => "کد تراکنش صحیح نیست",
            -35 => "ساختار کلید مجوز دهی صحیح نیست",
            -36 => "شماره سفارش ارسال نشد است",
            -37 => "شماره تراکنش یافت نشد",
            -38 => "توکن ارسالی موجود نیست",
            -39 => "کلید مجوز دهی موجود نیست",
            -40 => "کلید مجوزدهی مسدود شده است",
            -41 => "خطا در دریافت پارامتر، شماره شناسایی صحت اعتبار که از بانک ارسال شده موجود نیست",
            -42 => "سیستم پرداخت دچار مشکل شده است",
            -43 => "درگاه پرداختی برای انجام درخواست یافت نشد",
            -44 => "پاسخ دریافت شده از بانک نامعتبر است",
            -45 => "سیستم پرداخت غیر فعال است",
            -46 => "درخواست نامعتبر",
            -47 => "کلید مجوز دهی یافت نشد [حذف شده]",
            -48 => "نرخ کمیسیون تعیین نشده است",
            -49 => "تراکنش مورد نظر تکراریست",
            -50 => "حساب کاربری برای صندوق مالی یافت نشد",
            -51 => "شناسه کاربری یافت نشد",
            -52 => "حساب کاربری تایید نشده است",
            -60 => "ایمیل صحیح نیست",
            -61 => "کد ملی صحیح نیست",
            -62 => "کد پستی صحیح نیست",
            -63 => "آدرس پستی صحیح نیست و یا بیش از ۱۵۰ کاراکتر است",
            -64 => "توضیحات صحیح نیست و یا بیش از ۱۵۰ کارکتر است",
            -65 => "nنام و نام خانوادگی صحیح نیست و یا بیش از ۳۵ کاکتر است",
            -66 => "تلفن صحیح نیست",
            -67 => "نام کاربری صحیح نیست یا بیش از ۳۰ کارکتر است",
            -68 => "نام محصول صحیح نیست و یا بیش از ۳۰ کارکتر است",
            -69 => "آدرس ارسالی برای بازگشت موفق صحیح نیست و یا بیش از ۱۰۰ کارکتر است",
            -70 => "آدرس ارسالی برای بازگشت ناموفق صحیح نیست و یا بیش از ۱۰۰ کارکتر است",
            -71 => "موبایل صحیح نیست",
            -72 => "بانک پاسخگو نبوده است لطفا با نکست پی تماس بگیرید",
            -73 => "مسیر بازگشت دارای خطا میباشد یا بسیار طولانیست",
            -90 => "بازگشت مبلغ بدرستی انجام شد",
            -91 => "عملیات ناموفق در بازگشت مبلغ",
            -92 => "در عملیات بازگشت مبلغ خطا رخ داده است",
            -93 => "موجودی صندوق کاربری برای بازگشت مبلغ کافی نیست",
            -94 => "کلید بازگشت مبلغ یافت نشد",
            -1000 => "خطا در پاسخ سرور",
        );

        if (array_key_exists($error_code, $error_array)) {
            return $error_array[$error_code];
        } else {
            return "خطا : $error_code";
        }
    }
}