<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
* CodeIgniter IDPay getway library
*
* @author              Rayanik (http://rayanik.com)
* @package             IDPay
*/

class Idpay {

    private $authority;
    private $error_code;
    private $error_message;
    private $url;
    private $paid_amount;
    private $track_id;
    private $sandbox = 0; // 1 OR 0

    function send($api_key, $order_id, $amount, $call_back, $name = null, $phone = null, $mail = null, $desc = null) {
        try{

            $params = array(
                'order_id' => $order_id,
                'amount' => $amount,
                'name' => $name, 
                'phone' => $phone, 
                'mail' => $mail, 
                'desc' => $desc, 
                'callback' => $call_back,
                'reseller' => null,
            );

            // Create a cURL handle
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.idpay.ir/v1.1/payment');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'X-API-KEY: ' . $api_key,
                'X-SANDBOX: ' . $this->sandbox
            ));

            // Execute
            $result = curl_exec($ch);

            // Check HTTP status code
            if (!curl_errno($ch)) {
                $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            }

            // Close handle
            curl_close($ch);

            if(isset($http_code)){
                $result=  json_decode($result);
                if($http_code == 201){
                    //OK
                    $this->authority = $result->id;
                    $this->url = $result->link;

                    return true;
                }else{
                    //NOK
                    $this->error_code = $result->error_code;
                    $this->error_message = $result->error_message;

                    return false;
                }
            }
        } catch (\Throwable $th) {
            $this->error_code = $th->getCode();
            return false;
        }
    }

    function verify($api_key, $authority, $order_id) {
        try{
            $params = array(
                'id' => $authority,
                'order_id' => $order_id,
            );

            // Create a cURL handle
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.idpay.ir/v1.1/payment/verify');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'X-API-KEY: ' . $api_key,
                'X-SANDBOX: ' . $this->sandbox
            ));

            // Execute
            $result = curl_exec($ch);

            // Check HTTP status code
            if (!curl_errno($ch)) {
                $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            }

            // Close handle
            curl_close($ch);

            if(isset($http_code)){
                if($http_code == 200){
                    $result=  json_decode($result);
                    if($result->status == 100){
                        //OK
                        $this->paid_amount = $result->amount;
                        $this->track_id = $result->track_id;
                        return true;
                    }else{
                        //NOK
                        $this->error_code = $result->status;
                        $this->error_message = $this->get_status_message($result->status);
        
                        return false;
                    }
                }else{
                    $this->error_code = 0;
                    $this->error_message = 'خطای نا مشخص';

                    return false;
                }
                
                
            }
        }catch (\Throwable $th) {
            $this->error_code = $th->getCode();
            return false;
        }
    }

    public function get_authority()
    {
        return $this->authority;
    }

    public function redirect()
    {
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }
        redirect($this->url);
    }

    public function get_error()
    {
        return $this->error_message;
    }

    public function get_paid_amount()
    {
        return $this->paid_amount;
    }

    public function get_track_id()
    {
        return $this->track_id;
    }

    public function get_status_message($code){
        switch ($code) {
            case '1':
                $status_msg = 'پرداخت انجام نشده است.';
                break;
            case '2':
                $status_msg = 'پرداخت ناموفق بوده است.';
                break;
            case '3':
                $status_msg = 'خطا رخ داده است.';
                break;
            case '4':
                $status_msg = 'بلوکه شده.';
                break;
            case '5':
                $status_msg = 'برگشت به پرداخت کننده.';
                break;
            case '6':
                $status_msg = 'برگشت خورده سیستمی.';
                break;
            case '7':
                $status_msg = 'انصراف از پرداخت.';
                break;
            case '8':
                $status_msg = 'به درگاه پرداخت منتقل شد.';
                break;
            case '10':
                $status_msg = 'در انتظار تایید پرداخت.';
                break;
            case '100':
                $status_msg = 'پرداخت تایید شده است.';
                break;
            case '101':
                $status_msg = 'پرداخت قبلا تایید شده است.';
                break;
            case '200':
                $status_msg = 'به دریافت کننده واریز شد.';
                break;
            default:
                $status_msg = 'عملیات پرداخت ناموفق بود.';
                break;
        }

        return  $status_msg;
    }

}
