<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class MY_Model extends CI_Model {

    protected $_table_name = '';
    protected $_primary_key = 'id';
    protected $_primary_filter = 'intval';
    protected $_order_by = 'id';
    protected $_filter = NULL;
    public $rules = array();
    protected $_timestamps = FALSE;

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function array_from_post($fields) {
        $data = array();
        foreach ($fields as $field) {
            $data[$field] = $this->input->post($field);
        }
        return $data;
    }

    public function get($id = NULL, $single = FALSE) {

        if ($id != NULL) {
            $filter = $this->_primary_filter;
            $id = $filter($id);
            $this->db->where($this->_primary_key, $id);
            $method = 'row';
        } elseif ($single == TRUE) {
            $method = 'row';
        } else {
            $method = 'result';
        }
        
        if($this->_filter !=NULL){
            $this->db->where($this->_filter);
        }

//		if (!count($this->db->ar_orderby)) {
        $this->db->order_by($this->_order_by);
//		}

        if (is_array($this->_table_name)) {
            //$this->_table_name = implode();
        }
        return $this->db->get($this->_table_name)->$method();
    }

    public function get_by($select = NULL, $where = NULL, $single = FALSE, $order_by = NULL, $group_by = NULL,$limit=NULL) {
        if ($select != NULL)
            $this->db->select($select);
        
//        $this->db->select_max('update_date'); 
        
        if ($where != NULL)
            $this->db->where($where);
        if ($order_by != NULL)
            $this->db->order_by($order_by);
        if ($group_by != NULL)
            $this->db->group_by($group_by);
        if ($limit != NULL){
            if(isset($limit['start'])){
                $this->db->limit($limit['limit'],$limit['start']);// Produces: LIMIT $start, $limit (in MySQL.  Other databases have slightly different syntax)
            }else{
                $this->db->limit($limit['limit']);  
            }
        }
        
        return $this->get(NULL, $single);
    }

    public function save($data, $id = NULL) {

        // Set timestamps
        if ($this->_timestamps == TRUE) {
            $now = date('Y-m-d H:i:s');
            $id || $data['created'] = $now;
        }

        // Insert
        if ($id === NULL) {
            !isset($data[$this->_primary_key]) || $data[$this->_primary_key] = NULL;
            $this->db->set($data);
            $this->db->insert($this->_table_name);
            $id = $this->db->insert_id();
        }
        // Update
        else {
            $filter = $this->_primary_filter;
            $id = $filter($id);
            $this->db->set($data);
            $this->db->where($this->_primary_key, $id);
            $this->db->update($this->_table_name);
        }

        return $id;
    }
    
    public function insert_batch($data){
        $this->db->insert_batch($this->_table_name, $data); 
    }
    
    public function update_batch($data,$field,$where=NULL){
        if ($where != NULL) {
            $this->db->where($where);
        }
        $this->db->update_batch($this->_table_name, $data, $field);
    }

    public function delete($id) {
        $filter = $this->_primary_filter;
        $id = $filter($id);

        if (!$id) {
            return FALSE;
        }
        $this->db->where($this->_primary_key, $id);
        $this->db->limit(1);
        $this->db->delete($this->_table_name);
    }

    public function update($data, $id) {
        $filter = $this->_primary_filter;
        $id = $filter($id);

        if (!$id) {
            return FALSE;
        }
        $this->db->where($this->_primary_key, $id);
        $this->db->limit(1);
        $this->db->update($this->_table_name, $data);
    }
    
    
    public function update_by($data,$where) {
        if ($where != NULL) {
            $this->db->where($where);
            $this->db->update($this->_table_name, $data);
        }
    }

    public function delete_by($where) {
        if ($where != NULL) {
            $this->db->where($where);
            $this->db->delete($this->_table_name);
        }
    }
    
    public function delete_group($ids=null,$where=NULL) {
        if ($where != NULL) {
            $this->db->where($where);
        }
        $this->db->where_in('id',$ids);
        $this->db->delete($this->_table_name);
        
        
    }
    
    public function updateOrdering($new,$old){
        //اگر مقدار قبلی از مقدار فعلی کمتر بود
        if($old<$new){
            $this->db->where('ordering > ', $old);
            $this->db->where('ordering <= ', $new);
            $this->db->set('ordering', 'ordering-1', FALSE);
            $this->db->update($this->_table_name);
            return true;
        }
        //اگر مقدار قبلی از مقدار فعلی بیشتر بود
        else{
            $this->db->where('ordering < ', $old);
            $this->db->where('ordering >= ', $new);
            $this->db->set('ordering', 'ordering+1', FALSE);
            $this->db->update($this->_table_name);
            return true;
        }
    }
    
    //زمانی که میخواهیم یک آیتم جدید اضافه کنیم می بایست آن های که بزرگتر و مساوی ترتیب جدید هستند یک واحد اضافه کنیم
    public function updateOrderingInInsert($new){
            $this->db->where('ordering >= ', $new);
            $this->db->set('ordering', 'ordering+1', FALSE);
            $this->db->update($this->_table_name);
            return true;
    }

    //BEGIN FOR AJAX DATA TABLE
    private function _get_datatables_query() {

        $this->db->from($this->_table_ajax);
        
        if(isset($this->filter) && count($this->filter)){
            foreach ($this->filter as $key => $value) {
                $this->db->where($key,$value);
            }
        }
        
        $i = 0;

        foreach ($this->column_search as $item) { // loop column 
            if ($_POST['search']['value']) { // if datatable send POST for search
                if ($i === 0) { // first loop
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                } else {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }


        // multi columns search
        if (isset($_POST['columns']) && is_array($_POST['columns'])) {

            foreach ($_POST['columns'] as $column) {
                
                if(in_array($column['data'], $this->columns_search) && $column['search']['value']!=''){
                    if($column['search']['regex']=='false'){
                        $this->db->like($column['data'], $column['search']['value']);
                    }else{
                        $regexs=$column['search']['regex'];
                        if(is_array($regexs)&& count($regexs)){
                            foreach ($regexs as $regex) {
                                $this->db->where($column['data'].' REGEXP',$regex);
                            }
                        }
                    }
                }
            }
        }
        
        

        if (isset($_POST['order'])) { // here order processing 
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            if(count($this->order)){
                foreach ($this->order as $key => $value) {
                    $this->db->order_by($key,$value);
                }
            }
//            $order = $this->order;
//            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables() {

        $this->_get_datatables_query();
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered() {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all() {
        $this->db->from($this->_table_ajax);
        if(isset($this->filter) && count($this->filter)){
            foreach ($this->filter as $key => $value) {
                $this->db->where($key,$value);
            }
        }
        return $this->db->count_all_results();
    }

    //BEGIN FOR AJAX DATA TABLE
}
