<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');

class Products extends CI_Controller {

    public function __construct(){
        parent::__construct();
        header('Content-Type: application/json; charset=UTF-8');
        $this->load->helper('url');
        $this->load->helper('genaral_helper');
        $this->load->model('products_m');
        $this->load->model('settings_m');
	}
    
    public function index()
    {
        // Settings
        $settings = $this->settings_m->getSettings([
            'rate',
            'round_price',
            'default_category_large_image',
            'default_category_image',
        ]);
        $settings->rate = json_decode($settings->rate);

        $total_items = $this->products_m->getProducts((object)['get_count' => true]);
        $item_per_page = intval($this->input->get('item_per_page'));
        if($item_per_page <= 0){
            $item_per_page = 3;
        }
        $pages_count = ceil($total_items / $item_per_page);
        $page_num = intval($this->input->get('page'));
        if($page_num <= 0){
            $page_num = 1;
        }

        $products = [];
        $db_products = $this->products_m->getProducts((object)[
            'rate' => $settings->rate,
            'round_price' => $settings->round_price,
            'offset' => ($page_num - 1) * $item_per_page,
            'limit' => $item_per_page,
        ]);

        if($db_products){
            foreach ($db_products as $product) {
                // Image
                if($product->large_image && file_exists($product->large_image)){
                    $img = $product->large_image;
                } else if($product->image && file_exists($product->image)){
                    $img = $product->image;
                } else if($product->category_large_image && file_exists($product->category_large_image)){
                    $img = $product->category_large_image;
                } else if($product->category_image && file_exists($product->category_image)){
                    $img = $product->category_image;
                } else if($settings->default_category_large_image && file_exists($settings->default_category_large_image)){
                    $img = $settings->default_category_large_image;
                } else if($settings->default_category_image && file_exists($settings->default_category_image)){
                    $img = $settings->default_category_image;
                } else {
                    $img = '';
                }

                $sell_price = $product->sell_price * 1;

                $products[] = (object)[
                    'title' => $product->title,
                    'id' => $product->id,
                    'price' => $sell_price,
                    'old_price' => ($product->price) ? $product->price * 1 : $sell_price,
                    'category' => $product->category_title,
                    'image' => ($img) ? base_url($img) : '',
                    'is_available' => ($product->is_exists) ? TRUE : FALSE,
                    'url' => ($product->slug) ? base_url("product/$product->slug") : base_url("product/$product->id"),
                ];
            }
        }

        $response = [
            'success' => ($products) ? TRUE : FALSE,
            'total_items' => $total_items,
            'pages_count' => $pages_count,
            'item_per_page' => $item_per_page,
            'page_num' => $page_num,
            'products' => $products,
        ];

        echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }

}