<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Transactions extends Admin_Controller {

    public function __construct() {
        parent::__construct();

        $this->load->model('transactions_m');
        $this->load->library('pdate');
    }

    public function index() {
        $this->userHasPermission("transactions");
        $this->data['breadcrumb'] = array('تراکنش ها');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        array_push($css, 'assets/plugins/persian-datepicker/css/persian-datepicker.css?1');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        array_push($js, 'assets/plugins/persian-date/persian-date.js?1');
        array_push($js, 'assets/plugins/persian-datepicker/js/persian-datepicker.js?1');
        $this->data['js'] = $js;

        //gatewayes
        $this->load->model('gateways_m');
        $this->data['gatewayes'] = $this->gateways_m->get_by('title_en, title_fa', array('deleted'=>0), false, 'ordering');


        $this->data['subview'] = 'admin/transaction/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    public function view() {
        $this->userHasPermission("transactions", false);
        //gatewayes
        $this->load->model('gateways_m');
        $this->data['gatewayes'] = $this->gateways_m->get_by('title_en, title_fa', array('deleted'=>0), false, 'ordering');

        echo $this->load->view('admin/transaction/index', $this->data, true);
    }

    public function ajax_list() {
        $this->userHasPermission("transactions", false);

        // Gatewayes
        $this->load->model('gateways_m');
        $db_gatewayes = $this->gateways_m->get_by('title_en, title_fa', array('deleted'=>0), false);
        $gatewayes = array();
        if($db_gatewayes){
            foreach ($db_gatewayes as $gateway) {
                $gatewayes[strtolower($gateway->title_en)] = $gateway->title_fa;
            }
        }

        // Filter Start
        $this->transactions_m->filter = [];

        // Created
        $date_regex = '/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/';

        $from_date = NULL;
        $date = englishNumber($this->input->post('from_date'));
        if (preg_match($date_regex, $date)) {
            [$year, $month, $day] = explode('/', $date);
            $timestamp = $this->pdate->mktime($hour = 0, $minute = 0, $second = 0, $month, $day, $year);
            $from_date = date('Y-m-d H:i:s', $timestamp);
        }

        $to_date = NULL;
        $date = englishNumber($this->input->post('to_date'));
        if (preg_match($date_regex, $date)) {
            [$year, $month, $day] = explode('/', $date);
            $timestamp = $this->pdate->mktime($hour = 23, $minute = 59, $second = 59, $month, $day, $year);
            $to_date = date('Y-m-d H:i:s', $timestamp);
        }

        if($from_date && $to_date){
            $this->transactions_m->filter["created >= "] = $from_date;
            $this->transactions_m->filter["created <= "] = $to_date;
        }elseif ($from_date) {
            $this->transactions_m->filter["created >= "] = $from_date;
        }elseif ($to_date) {
            $this->transactions_m->filter["created <= "] = $to_date;
        }
        // Filter End

        $list = $this->transactions_m->get_datatables();

        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {




            // Amount
            if($item->completed){
                $color = ($item->amount > 0) ? 'label label-success' : 'label label-default';
            } else {
                $color = ($item->reject) ? 'label label-danger' : 'label label-warning';
            }
            $plus = ($item->amount > 0) ? '+' : '';
            $amount = "<div class=\"{$color}\">{$plus}".number_format($item->amount)."</div>";

            if($item->completed && $item->amount_dollar){
                $rate =  $item->dollar_rate ? number_format($item->dollar_rate) : '0';
                $dollar_amount = floatval($item->amount_dollar);
                $amount.= "<div class=\"font-sm label-info curve m-t-5 p-10\"><span class=\"iransans-en\">مبلغ دلاری: $dollar_amount </span><span>قیمت دلار: $rate</span></div>";
            }

            // Actions
            $actions = '';
            if (in_array('transactions_edit', $this->user_permissions)){
                $actions .= "<a title=\"توضیحات\" class=\"btn btn-warning btn-round btn-icon has-tooltip\" href=\"$base_url/admin/transactions/edit/$item->id\"><i class=\"icon-pencil\"></i></a>";
            }

            $no++;
            $row = array();
            $row['row'] = $no;
            $row['tracking_code'] = $item->tracking_code;
            $row['cell_phone'] = $item->cell_phone;
            $row['amount'] = $amount;
            $row['reference'] = $item->reference;
            $row['type'] = getTransactionTypes($item->type);
            $row['gateway'] = (isset($gatewayes[strtolower($item->gateway)])) ? $gatewayes[strtolower($item->gateway)] : '';
            $row['created'] = $this->pdate->date('Y/m/d H:i', strtotime($item->created));
            $row['actions'] = $actions;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->transactions_m->count_all(),
            "recordsFiltered" => $this->transactions_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }


    function edit($id = null, $user_id = null) {

        $id = intval($id);
        $user_id = intval($user_id);
        if ($id) {
            $this->userHasPermission("transactions_edit");
            $this->data['breadcrumb'] = array('ثبت تراکنش');
            $transaction = $this->transactions_m->get_by(null, ['id' => $id], true);
            if(!$transaction){
                redirect('admin/transactions');
            }
            $user_id = $transaction->user_id;
        } else {
            $this->userHasPermission("transactions_add");
            $this->data['breadcrumb'] = array('ویرایش توضیحات تراکنش');
            $transaction = $this->transactions_m->getNew();
        }

        if($transaction->gateway == 'card2card'){
            $transaction->detail = json_decode($transaction->detail);
        }
        $this->data['transaction'] = $transaction;

        // User
        $where = ['id' => intval($user_id)];
        if(!$transaction){
            $where['deleted'] = 0;
        }
        $user = $this->users_m->get_by('id, cell_phone, first_name , last_name', $where, true);
        if(!$user){
            $this->session->set_flashdata('admin_error', 'کاربر یافت نشد!');
            redirect('admin/customers');
        }
        $this->data['user'] = $user;

        // Credit
        $this->data['credit'] = $this->users_m->getCredit($user->id);
        

        $this->data['subview'] = 'admin/transaction/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // Save
    function save() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $id = intval($this->input->post('id'));
        $user_id = intval($this->input->post('user_id'));

        if ($id) {
            $this->userHasPermission("transactions_edit", false, $result);
            $transaction = $this->transactions_m->get_by(null, ['id' => $id], true);
            if(!$transaction){
                $result->msg = 'تراکنش یافت نشد.';
                echo json_encode($result, JSON_UNESCAPED_UNICODE);
                die();
            }
            $user_id = $transaction->user_id;
        } else {
            $this->userHasPermission("transactions_add", false, $result);
            $transaction = null;
        }

        // User
        $where = ['id' => intval($user_id)];
        if(!$transaction){
            $where['deleted'] = 0;
        }
        $user = $this->users_m->get_by('id', $where, true);
        if(!$user){
            $result->msg = 'کاربر یافت نشد.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }

        $credit = $this->users_m->getCredit($user->id);

        if($transaction){
            $this->form_validation->set_rules('description', 'توضیحات', 'trim');
        } else {
            $this->form_validation->set_rules('amount', 'مبلغ', 'trim|required|regex_match[/^[0-9,]+$/]');
            $this->form_validation->set_rules('action', 'عملیات', 'trim|required|in_list[increase,decrease]');
        }

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('regex_match', '%s را به درستی وارد کنید');
        $this->form_validation->set_message('in_list', '%s را به درستی انتخاب کنید');

        if ($this->form_validation->run() != FALSE) {
            if(!$transaction){

                $action = $this->input->post('action');
                $amount = str_replace(',', '', $this->input->post('amount')) * 1;

                if ($amount <= 0) {
                    $result->msg = 'مبلغ را وارد کنید.';
                    echo json_encode($result, JSON_UNESCAPED_UNICODE);
                    die();
                }
    
                if ($action == 'decrease' && $amount > $credit) {
                    $result->msg = 'برای کاهش موجودی مبلغ شما نباید از مبلغ موجودی بیشتر باشد.';
                    echo json_encode($result, JSON_UNESCAPED_UNICODE);
                    die();
                }
            }

            
            $data = [
                'description' => $this->input->post('description'),
            ];

            if ($transaction) {
                $this->transactions_m->save($data, $transaction->id);
            } else {
                $amount = ($action == 'decrease') ? $amount * -1 : $amount;
                $data['user_id'] = $user_id;
                $data['amount'] = $amount;
                $data['type'] = 'manual';
                $data['completed'] = 1;
                $this->transactions_m->save($data);
            }
           
            $result->msg = 'با موفقیت ثبت گردید.';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/transactions');
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    } 
    
    // Change Status card2card
    function changeStatus($status = null) {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $this->userHasPermission("transactions_edit", false, $result);

        $id = intval($this->input->post('id'));
        $transaction = $this->transactions_m->get_by(null, ['id' => $id], true);
        if(!$transaction){
            $result->msg = 'تراکنش یافت نشد.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }

        if(!in_array($status, ['accept', 'reject'])){
            $result->msg = 'عملیات خواسته شده مجاز نیست.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }
        
        if(
            $transaction->gateway == 'card2card' && 
            !$transaction->order_id &&
            !$transaction->completed &&
            !$transaction->reject
        ){
            if($status == 'accept'){
                $this->transactions_m->save(['completed' => 1], $transaction->id);
                $result->msg = 'با موفقیت تایید شد.';
            } else {
                $this->transactions_m->save(['reject' => 1], $transaction->id);
                $result->msg = 'با موفقیت رد شد.';
            }

            // Send SMS
            if($this->input->post('send_sms')){
                $sms = $this->settings_m->getSingle('sms');
                $sms = json_decode($sms);
                if($status == 'accept'){
                    $pattern = isset($sms->patterns->card2card_accept) ? $sms->patterns->card2card_accept : '';
                } else {
                    $pattern = isset($sms->patterns->card2card_reject) ? $sms->patterns->card2card_reject : '';
                }
                if($sms->active && $sms->api_key && $pattern){
                    $user = $this->users_m->get_by('cell_phone', ['id' => $transaction->user_id], true);
                    if($user){
                        $this->load->library($sms->active, null, 'sms');
                        $sms_status = $this->sms->send_by_token($sms->api_key, $sms->from, $user->cell_phone, $pattern, number_format($transaction->amount));
                    }
                }
            }

            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/transactions/edit/'.$transaction->id);

        } else {
            $result->msg = 'عملیات خواسته شده امکان پذیر نیست.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }

        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    }

}
