<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Menus extends Admin_Controller {

    function __construct() {
        parent::__construct();

        // check user permission
        $this->load->model('menus_m');
        $this->load->model('menu_types_m');
    }

    //صفحه اصلی
    function type($menu_type_id = null) {
        $this->userHasPermission('menus');
        $menu_type = $this->menu_types_m->get($menu_type_id, true);

        if (!$menu_type){
            redirect('admin/dashboard');
        }

        //css
        $css = array();
        array_push($css, 'assets/plugins/nestable/nestable.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/nestable/jquery.nestable.js');
        $this->data['js'] = $js;

        $this->data['menu_type'] = $menu_type;
        $this->data['breadcrumb'] = array('مدیریت منو');

        //menus
        $this->data['menus'] = $this->getMenu($menu_type_id);

        //به دست آوردن لیست صفحات
        $this->load->model('pages_m');
        $pages = $this->pages_m->get_by('title, id, slug', array('publish' => '1'));
        $this->data['pages'] = $pages;

        $this->data['subview'] = 'admin/menu/index';
        $this->load->view('admin/_layout_main', $this->data);
    }


    //رسم منو
    function nestable($menu_type_id = null) {
        $this->userHasPermission('menus', false);

        $menu_type = $this->menu_types_m->get($menu_type_id, true);

        if (!$menu_type) {
            echo 'این منو وجود ندارد';
            return;
        }

        $this->data['menu_type'] = $menu_type;

        //menus
        $this->data['menus'] = $this->getMenu($menu_type_id);

        echo $this->load->view('admin/menu/nestable', $this->data, true);
    }

    //edit
    function edit($id = null) {
        $this->userHasPermission('menus_edit');

        // check exist
        $id=intval($id);

        $menu = $this->menus_m->get($id, true);
        if (!$menu){
            redirect('admin');
        }

        // edit
        $this->data['breadcrumb'] = array('ویرایش منو');

        // load page info
        $this->data['menu'] = $menu;

        $this->data['subview'] = 'admin/menu/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    //حذف آیتم مورد نظر و فرزندانش
    function delete($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا.';

	$this->userHasPermission('menus_delete', false, $result);

        if ($id != '' && (int) $id > 0) {
            $id = intval($id);
            //ابتدا فرزندانش را به دست می آوریم
            $menu = $this->menus_m->get_by('menu_type_id', array('id' => $id),true);
            if ($menu) {
                $menu_type_id=$menu->menu_type_id;
                $childrens=$this->chidren_find($this->getMenu($menu_type_id),$id);
                $childrens=  explode(',', $childrens);
                //حذف فرزندان
                foreach ($childrens as $children_id) {
                    $this->menus_m->delete($children_id);
                }
            }
            $this->menus_m->delete($id);

            $result->msg = 'آیتم مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        }
        echo json_encode($result);
    }

    function publish($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا';

        $this->userHasPermission('menus_edit', false, $result);

        if ($id != '' && (int) $id > 0) {
            $id = intval($id);
            //ابتدا فرزندانش را به دست می آوریم
            $menu = $this->menus_m->get_by('menu_type_id, publish', array('id'=>$id),true);
            if ($menu) {
                $menu_type_id=$menu->menu_type_id;
                $childrens=$this->chidren_find($this->getMenu($menu_type_id),$id);
                $childrens=  explode(',', $childrens);

                if($menu->publish==1){
                    $data = array(
                        'publish' => '0'
                    );
                }else{
                    $data = array(
                        'publish' => '1'
                    );
                }
                //تغییر وضعیت فرزندان
                foreach ($childrens as $children_id) {
                    $this->menus_m->save($data, $children_id);
                }

                $this->menus_m->save($data, $id);
            }

            if($data['publish']){
                $result->msg = 'آیتم با موفقیت در وضعیت انتشار قرار گرفت.';
            }else{
                $result->msg = 'آیتم با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            }
            $result->condition = true;
        }
        echo json_encode($result);
    }

    // اضافه کردن یک آیتم جدید
    function saveAdd($menu_type_id = null) {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $this->userHasPermission('menus_add', false, $result);

        $data = $this->input->post();
        $menu_type = $this->menu_types_m->get($menu_type_id, true);

        //اگر چنین منوی وجود نداشت
        if (!$menu_type) {
            $result->condition = false;
            $result->msg = 'این منو وجود ندارد';
        } else {

            //به دست آوردن ته لیست
            $last_ordering = 0;
            $menus = $this->menus_m->get_by('max(ordering) as ordering', array('menu_type_id' => $menu_type_id, 'parent' => '0'), true, 'ordering DESC');
            if ($menus) {
                $last_ordering = $menus->ordering;
            }

            $insert = FALSE;
            if (isset($data['items'])) {
                foreach ($data['items'] as $key => $item) {
                    if (isset($item['checked'])) {
                        $last_ordering++;
                        $data_save = array(
                            'menu_type_id' => $menu_type_id,
                            'title' => $item['title'],
                            'url' => $item['url'],
                            'type' => $item['type'],
                            'ordering' => $last_ordering
                        );

                        if ($this->menus_m->save($data_save)) {
                            $insert = true;
                        }
                    }
                }
            }

            if ($insert) {
                $result->msg = 'آیتم با موفقیت ثبت و به انتهای لیست اضافه گردید';
                $result->condition = true;
            } else {
                $result->msg = 'لطفا حداقل یک مورد را انتخاب کنید.';
            }
        }

        echo json_encode($result);
    }

    // اضافه کردن یک آیتم جدید در لینک سفارشی
    function saveAddCustom($menu_type_id = null) {
        $result = new stdClass();
        $result->condition = false;
        $result->csrf = $this->security->get_csrf_hash();
        $this->userHasPermission('menus_add', false, $result);

        $data = $this->input->post();
        $menu_type = $this->menu_types_m->get($menu_type_id, true);

        //اگر چنین منوی وجود نداشت
        if (!$menu_type) {
            $result->msg = 'این منو وجود ندارد';
        } else {
            $this->form_validation->set_rules('title', 'عنوان', 'trim|required');
            $this->form_validation->set_rules('url', 'لینک', 'trim|required');

            $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');

            if ($this->form_validation->run() != FALSE) {

                //به دست آوردن ته لیست
                $last_ordering = 0;
                $menus = $this->menus_m->get_by('max(ordering) as ordering', array('menu_type_id' => $menu_type_id, 'parent' => '0'), true, 'ordering DESC');
                if ($menus) {
                    $last_ordering = $menus->ordering;
                }
                $last_ordering++;

                $data_save = array(
                    'menu_type_id' => $menu_type_id,
                    'title' => $data['title'],
                    'url' => $data['url'],
                    'type' => 'custom',
                    'ordering' => $last_ordering
                );

                if ($this->menus_m->save($data_save))
                    $result->msg = 'با موفقیت ثبت گردید';
                $result->condition = true;
            } else {
                $result->msg = validation_errors();
            }
        }

        echo json_encode($result);
    }

    // update
    function saveEdit() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $this->userHasPermission('menus_edit', false, $result);

        $this->form_validation->set_rules('title', 'عنوان', 'trim|required');
        $this->form_validation->set_rules('url', 'لینک', 'trim|required');

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s باید مقداری صحیح و عدد باشد');

        if ($this->form_validation->run() != FALSE) {
            //Edit
            $id = intval($this->input->post('id'));
            $data = [
                'title' => $this->input->post('title'),
                'url' => $this->input->post('url'),
            ];
            $id = $this->menus_m->save($data, $id);

            $result->msg = 'با موفقیت ثبت گردید';
            $result->condition = true;
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->url = base_url('admin/menus/type/'.$this->input->post('menu_type_id'));
        } else {
            $result->msg =  validation_errors();
        }

        echo json_encode($result);
    }

    // save
    function saveSort($menu_type_id) {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $data = $this->input->post();

        $this->form_validation->set_rules('list', 'لیست', 'trim|required');

        if ($this->form_validation->run() != FALSE) {
            $list = json_decode($data['list'], true);

            if ($list) {
                $this->saveList($list);
            }

            $result->msg = 'به انتهای لیست اضافه شد و با موفقیت ثبت گردید';
            $result->condition = true;
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    //به دست آوردن کل منوی مود نظر به صورت درختی
    public function getMenu($menu_type_id) {

        //===================menu=======================
        $refs = array();
        $list = array();

        $menus = $this->menus_m->get_by(null, array('menu_type_id' => $menu_type_id));

        foreach ($menus as $menu) {
            $ref = & $refs[$menu->id];

            $ref['parent'] = $menu->parent;
            $ref['title'] = $menu->title;
            $ref['id'] = $menu->id;
            $ref['publish'] = $menu->publish;
            $ref['type'] = $menu->type;
            $ref['category_id'] = $menu->category_id;

            if ($menu->parent == 0) {
                $list[$menu->id] = & $ref;
            } else {
                $refs[$menu->parent]['children'][$menu->id] = & $ref;
            }
        }
        return $list;
    }

    //ذخیره کل منو به صورت بازگشتی
    public function saveList($list, $parent = 0, &$m_order = 0) {
        foreach ($list as $item) {
            $m_order++;

            $data = array(
                'parent' => $parent,
                'ordering' => $m_order
            );

            $this->menus_m->save($data, $item['id']);

            if (array_key_exists("children", $item)) {
                $this->saveList($item["children"], $item["id"], $m_order);
            }
        }
    }

    //به دست آوردن فرزندان
    function chidren_find(array $array, $parent) {
        $children = '';
        foreach ($array as $key => $value) {
            if ($key == $parent) {

                if (!empty($value['children'])) {
                    $result = $this->chidren_list($value['children']);
                    $children .= trim($result, ',');
                }
            } else {
                if (!empty($value['children'])) {
                    $children.=$this->chidren_find($value['children'], $parent);
                }
            }
        }
        return $children;
    }

//آی دی فرزندان را برمیگردانیم
    function chidren_list(array $array) {
        $ids = "";
        foreach ($array as $value) {
            $ids .= $value['id'] . ',';
            if (!empty($value['children'])) {
                $ids .= $this->chidren_list($value['children']);
            }
        }
        return $ids;
    }

}
?>
