<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gateways extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('gateways_m');
    }

    // Load gateways list
    function index() {
        $this->userHasPermission('gateways');
        $this->data['breadcrumb'] = array('درگاه پرداخت');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;


        //gateways
        $this->data['gateways'] = $this->gateways_m->get_by(null, array('deleted'=>0));

        // اگر کارت پرداختی می‌بایست با کد ملی تطابق داشته باشد باید مراقب باشیم هر درگاهی فعال نشود
        $verify_when_buy = json_decode($this->settings_m->getSingle('verify_when_buy'));
        $check_card_number = (in_array('bank_card', $verify_when_buy)) ? true : false;
        if($check_card_number){
            $gateways_check_card = $this->gateways_m->get_by('title_en', [
                'deleted' => 0, 
                'check_card <>' => ''
            ]);
            $this->data['gateways_check_card']  = array_map(function($item){
                 return $item->title_en;
            }, $gateways_check_card);
        }
        $this->data['check_card_number'] = $check_card_number;

        $this->data['subview'] = 'admin/gateway/index';

        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('gateways', false);
        // Gateways
        $this->data['gateways'] = $this->gateways_m->get_by(null, array('deleted'=>0));

        // اگر کارت پرداختی می‌بایست با کد ملی تطابق داشته باشد باید مراقب باشیم هر درگاهی فعال نشود
        $verify_when_buy = json_decode($this->settings_m->getSingle('verify_when_buy'));
        $check_card_number = (in_array('bank_card', $verify_when_buy)) ? true : false;
        if($check_card_number){
            $gateways_check_card = $this->gateways_m->get_by('title_en', [
                'deleted' => 0, 
                'check_card <>' => ''
            ]);
            $this->data['gateways_check_card']  = array_map(function($item){
                 return $item->title_en;
            }, $gateways_check_card);
        }
        $this->data['check_card_number'] = $check_card_number;

        echo $this->load->view('admin/gateway/index', $this->data, true);
    }

    // Ordering
    function ordering($id = null, $value = null) {
        $value = intval($value);
        $id = intval($id);
        $data = array(
            'ordering' => $value
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا';

        $this->userHasPermission('gateways_edit', false, $result);

        if ($id > 0) {
            //به دست آوردن ترتیب فعلی این آیتم
            $gateway = $this->gateways_m->get($id, TRUE);
            if ($gateway) {
                //اگر تغییری نکرده بود
                if ($value == $gateway->ordering) {
                    $result->msg = 'ترتیب نمایش تغییر نکرد.';
                } else {
                    $this->gateways_m->save($data, $id);
                    $result->msg = 'ترتیب با موفقیت تغییر کرد.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }


    // Edit gateway
    function edit($id = null) {
        $this->userHasPermission('gateways_edit');
        $this->data['breadcrumb'] = 'درگاه پرداخت';

        // Check exist
        $id = intval($id);
        $gateway = $this->gateways_m->get_by(null, ['id' => $id], true);
        if (!$gateway)
            redirect('admin/gateways');

        $this->data['gateway'] = $gateway;

        if($gateway->title_en == 'card2card'){
            // JS
            $js = array();
            array_push($js, 'assets/plugins/ckeditor-full/ckeditor.js');
            $this->data['js'] = $js;

            $this->data['card2card_alert'] = $this->settings_m->getSingle('card2card_alert');
        }

        $this->data['subview'] = 'admin/gateway/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // Save edit
    function save() {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $result->csrf = $this->security->get_csrf_hash();

        $this->userHasPermission('gateways_edit', false, $result);

        $id = intval($this->input->post('id'));

        // Check exist
        $gateway = $this->gateways_m->get_by(null, ['id' => $id], true);
        if (!$gateway){
            $result->msg = 'خطای سیستمی.';
            echo json_encode($result, JSON_UNESCAPED_UNICODE);
            die();
        }

        //$this->form_validation->set_rules('title_en', 'عنوان درگاه پرداخت', 'trim|required');
        $this->form_validation->set_rules('title_fa', 'عنوان فارسی درگاه', 'trim|required');
        // $this->form_validation->set_rules('ordering', 'ترتیب نمایش', 'numeric|required');

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s باید عدد باشد');

        if ($this->form_validation->run() != FALSE) {

            $data = array(
                //'title_en'       => $this->input->post('title_en'),
                'token'       => $this->input->post('token'),
                'username'    => strval($this->input->post('username')),
                'password'    => strval($this->input->post('password')),
                'title_fa' => $this->input->post('title_fa'),
                'ordering'    => intval($this->input->post('ordering')),
                // 'sandbox'     => $this->input->post('sandbox')==1?1:0,
                // 'publish'     => $this->input->post('publish')==1?1:0
            );

            $id = $this->gateways_m->save($data, $id);

            // Card2card alert
            if($gateway->title_en == 'card2card'){
                $this->settings_m->save(['value' => $this->input->post('card2card_alert')], 'card2card_alert');
            }
            
            if ($id) {
                //==================image=============================
                $image_result = $this->uploadImage('image');
                if ($image_result->condition) {
                    $source_image = $image_result->file_path;
                    list($width, $height, $type, $attr) = getimagesize($source_image);

                    if ($width != 50 || $height != 50) {
                        //در این حالت نیاز به برش و تغییر اندازه داریم 
                        $this->load->library('image_lib');
                        $config['source_image'] = $source_image;
                        $config['new_image'] = $source_image;
                        $config['maintain_ratio'] = FALSE;
                        $config['width'] = 50;
                        $config['height'] = 50;

                        $this->image_lib->set_enlarge(TRUE);
                        $this->image_lib->thumb($config);
                    }

                    $data = array(
                        'image' => $source_image
                    );
                    $this->gateways_m->save($data, $id);
                }

                $result->msg = 'با موفقیت ثبت گردید.';
                $this->session->set_flashdata('admin_success', $result->msg);
                $result->condition = true;
                $result->url = base_url('admin/gateways');
            }

        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    // Set default
    function defaultGateway($id) {
        $data = array(
            'is_default' => '1'
        );
        $dataReset =  array(
            'is_default' => '0'
        );
        
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی';
        
        $this->userHasPermission('gateways_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {

            $this->gateways_m->update_by($dataReset, array('id>'=>'0'));

            $this->gateways_m->update($data, $id);
            $result->msg = 'درگاه پرداخت مورد نظر با موفقیت در حالت پیش فرض قرار گرفت.';
            $result->condition = true;
        }

        echo json_encode($result);
    }

    // Set gateway publish
    function publish($id = '') {

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('gateways_edit', false, $result);

        $id = intval($id);
        $ids = [];
        if ($id > 0) {
            $ids[] = $id;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $ids[] = intval($id);
                    }
                    
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $where = ["id IN ($str_ids)" => null];

            // اگر کارت پرداختی می‌بایست با کد ملی تطابق داشته باشد باید مراقب باشیم هر درگاهی فعال نشود
            $verify_when_buy = json_decode($this->settings_m->getSingle('verify_when_buy'));
            if(in_array('bank_card', $verify_when_buy)){
                $where["(title_en = 'card2card' OR check_card <> '')"] = null;
            }
            $gateways = $this->gateways_m->get_by('id', $where);
            if($gateways){
                $ids = array_map(function($item){
                    return $item->id;
                }, $gateways);
                $str_ids = implode(',', $ids);
                $this->gateways_m->update_by(['publish' => '1'], ["id IN ($str_ids)" => null]);
                if(count($ids) == 1){
                    $result->msg = 'درگاه پرداخت مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
                } else {
                    $result->msg = 'درگاه پرداخت های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
                }
                $result->condition = true;
            }
        }

        echo json_encode($result);
    }

    // Set gateway unpublish
    function un_publish($id = '') {
        $data = array(
            'publish' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('gateways_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->gateways_m->update($data, $id);
            $result->msg = 'درگاه پرداخت مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->gateways_m->update($data, $id);
                    }
                    $result->msg = 'درگاه پرداخت های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    // Uplaod gateway image
    private function uploadImage($name = NULL, $path = '') {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {
            $this->load->library('upload');

            $output_dir = "media/gateways/";
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }

            if ($path) {
                $output_dir = $path;
            }
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . rand(1000, 9999) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|jpeg|png';
            $config['max_size'] = 2048; //(in kilobyte) 2 MB = 2048 KB


            $this->upload->initialize($config);
            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
            //if (!move_uploaded_file($_FILES[$name]['tmp_name'], $output_dir . $fileName)) {
            //    $result->error = 'Error in uploading.';
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }
    
    // Remove image
    public function removeImage($id = 0) {
        $result = new stdClass();
        $result->condition = FALSE;
        $this->userHasPermission('gateways_edit', false, $result);

        $id = intval($id);
        if ($id != 0) {
            $where = array(
                'id' => $id
            );
            $gateway = $this->gateways_m->get_by(NULL, $where, TRUE);
            if ($gateway) {
                if ($gateway->image != '' && file_exists($gateway->image)) {
                    unlink($gateway->image);
                    $data = array(
                        'image' => ''
                    );
                    $this->gateways_m->save($data, $id);
                }
                $result->condition = TRUE;
            }
        }

        echo json_encode($result);
    }
}
?>
