<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Dashboard extends Admin_Controller {

    public function __construct() {
        parent::__construct();
    }

    public function index() {
        $this->data['meta_title'] = '';
        $this->data['breadcrumb'] = 'پیشخوان';
        $this->data['url'] = 'dashboard';

        //js
        $js = array();
        array_push($js, 'assets/plugins/jquery-incremental-counter/jquery.incremental-counter.min.js');
        array_push($js, 'assets/plugins/chart.js/dist/Chart.bundle.min.js');
        $this->data['js'] = $js;

        if (in_array('users', $this->user_permissions)){
            $this->data['users_count'] = $this->users_m->get_by('COUNT(id) AS number', array('deleted' => '0', 'type' => 'admin'), true)->number;
        }

        if (in_array('products', $this->user_permissions)){
            $this->load->model('products_m');
            $this->data['products_count'] = $this->products_m->getCountForDashboard();
        }

        //sql directory
        $path_sql = ROOTPATH .DS. 'sql' .DS;
        $files = glob( $path_sql ."*" );
        $file_count  = ($files) ? count($files) : 0;
        if ($file_count){
            $this->data['warning'] = '<p>پوشه sql و فایل های درونش را برای امنیت سایتتان پاک کنید.</p>';
        }

        if (in_array('orders', $this->user_permissions)){
            // Statistics limitation
            $days_count = 10;
            $months_count = 12;

            // Start daily stats
            for ($i = 0; $i < $days_count; $i++) {
                if ($i == 0) {
                    $from_date = time();
                } else {
                    $from_date = strtotime("-$i day");
                }

                $days[] = $this->pdate->date("Y/m/d", $from_date);
            }

            $from_date = $days[$days_count - 1];
            $daily_stats = $this->orders_m->getStatistics('day', $from_date);
            if ($daily_stats) {
                $exist_days = array_map(function($element) {
                    return $element->date_formatted;
                }, $daily_stats);
                foreach ($days as $day) {
                    if (!in_array($day, $exist_days)) {
                        // Add an empty record to db statistics
                        $row = new stdClass();
                        $row->total = '0';
                        $row->count = '0';
                        $row->date_formatted = $day;
                        $daily_stats[] = $row;
                    }
                }
            }
            // Sort result, empty result by date
            usort($daily_stats, array($this, 'compare'));



            // Start monthly stats
            $month = intval($this->pdate->date("m", time()));
            $year = intval($this->pdate->date("Y", time()));
            for ($i = 0; $i < $months_count; $i++) {
                if($i != 0){
                    $month--;
                    if($month == 0){
                        $month = 12;
                        $year--;
                    }
                }
                $m = (strlen($month) == 1) ? "0".$month : $month;
                $months[] = "$year/$m";
            }

            $from_date = $months[$months_count - 1];
            $monthly_stats = $this->orders_m->getStatistics('month', $from_date);
            if ($monthly_stats) {
                $exist_months = array_map(function($element) {
                    return $element->date_formatted;
                }, $monthly_stats);
                foreach ($months as $month) {
                    if (!in_array($month, $exist_months)) {
                        // Add an empty record to db statistics
                        $row = new stdClass();
                        $row->total = '0';
                        $row->count = '0';
                        $row->date_formatted = $month;
                        $monthly_stats[] = $row;
                    }
                }
            }
            // Sort result, empty result by date
            usort($monthly_stats, array($this, 'compare'));

            foreach ($monthly_stats as $stat) {
                $stat->date_formatted = $this->pdate->getMonthNames(substr($stat->date_formatted, -2));
            }

            $this->data['daily_stats'] = $daily_stats;
            $this->data['monthly_stats'] = $monthly_stats;
        }

        $this->data['subview'] = 'admin/dashboard/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    private function compare($a, $b) {
        return strcmp($a->date_formatted, $b->date_formatted);
    }
}
