<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Customers extends Admin_Controller
{

    function __construct()
    {
        parent::__construct();
    }

    // Load list customers
    function index()
    {
        $this->userHasPermission('customers');
        $this->data['breadcrumb'] = array('مدیریت  مشتریان');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        $this->data['subview'] = 'admin/customer/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function view()
    {
        $this->userHasPermission('customers', false);
        echo $this->load->view('admin/customer/index', $this->data, true);
    }


    public function ajax_list()
    {
        $this->userHasPermission('customers', false);
        $list = $this->users_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            if ($item->block == 1) {
                $btn_class = 'danger';
                $title = 'بلاک شده';
                $url = "$base_url/admin/customers/unblock/$item->id";
            } else {
                $btn_class = 'success';
                $title = 'در وضعیت فعال';
                $url = "$base_url/admin/customers/block/$item->id";
            }
            $actions = "";
            if (in_array('customers_edit', $this->user_permissions)){
                $actions .= "<a title=\"ویرایش\" class=\"btn btn-warning btn-round btn-icon has-tooltip\" href=\"$base_url/admin/customers/edit/$item->id\"><i class=\"icon-pencil\"></i></a>";
                $actions .= "<a title=\"$title\" class=\"btn btn-$btn_class btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"insert('$url', '#frm-main', '$base_url/admin/customers/view', '#res', '#msg', false, true, 'noty' )\"><i class=\"icon-lock\"></i></a>";
            }
            if (in_array('transactions_add', $this->user_permissions)){
                $actions .= "<a title=\"ثبت تراکنش\" class=\"btn btn-info btn-round btn-icon has-tooltip\" href=\"$base_url/admin/transactions/add/$item->id\"><i class=\"icon-credit-card\"></i></a>";
            }
            if (in_array('customers_delete', $this->user_permissions)){
                $actions .= "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/customers/delete/$item->id','#frm-main','$base_url/admin/customers/view','#res','delete')\"><i class=\"icon-trash\"></i></a>";
            }

            $checkbox = '<input type="checkbox" value="' . $item->id . '">';

            $no++;
            $row = array();
            $row['checkbox'] = $checkbox;
            $row['row'] = $no;
            $row['first_name'] = html_escape($item->first_name);
            $row['last_name'] = html_escape($item->last_name);
            $row['cell_phone'] = $item->cell_phone;
            $row['national_code'] = $item->national_code;
            $row['email'] = '<p class="ellipsis ltr" style="width:120px;" title="' . html_escape($item->email) . '">' . html_escape($item->email) . '</p>';
            $row['status'] = ($item->status == 'accept') ? '<span class="label label-success">تایید شده</span>' : '<span class="label label-danger">تایید نشده</span>';
            $row['actions'] = $actions;
            $row['id'] = $item->id;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->users_m->count_all(),
            "recordsFiltered" => $this->users_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

    public function block($id = NULL)
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';
        
        $this->userHasPermission('customers_edit', false, $result);
        
        $id = intval($id);
        $ids = [];

        if ($id > 0) {
            $ids[] = $id;
        } elseif ($list = $this->input->post('list_ids')) {
            $ids = array_filter(array_map('intval', explode(',', $list)), fn($v) => $v > 0);
        }

        $ids = array_unique($ids);

        if(!$ids){
            echo json_encode($result);
            return;
        }

        $block_setting = json_decode($this->settings_m->getSingle('smart_block'));
        if(isset($block_setting->active) && $block_setting->active){
            $this->load->model('blocks_m');
            foreach ($ids as $id) {
                $this->blocks_m->smartBlockUsers($id, 'admin');
            }
        } else {
            $str_ids = implode(',', $ids);
            $this->users_m->update_by(['block' => 1], [
                "id IN ($str_ids)" => null,
                'type' => 'customer',
            ]);
        }

        $result->msg = count($ids) === 1 
            ? 'مشتری مورد نظر با موفقیت بلاک شد.' 
            : 'مشتری‌های مورد نظر با موفقیت بلاک شدند.';
            
        $result->condition = true;
        echo json_encode($result);
    }

    public function unblock($id = NULL)
    {
        $id = intval($id);
        $data = array(
            'block' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';
        
        $this->userHasPermission('customers_edit', false, $result);

        if ($id > 0) {
            $id = intval($id);
            $this->users_m->update_by($data, array('id' => $id));
            $result->msg = 'مشتری مورد نظر با موفقیت بازیابی شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->users_m->update_by($data, array('id' => $id, 'type' => 'customer'));
                    }
                    $result->msg = 'مشتری های مورد نظر با موفقیت بازیابی شدند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    public function delete($id = NULL)
    {
        $id = intval($id);
        $data = array(
            'deleted' => '1'
        );
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('customers_delete', false, $result);

        if ($id > 0) {
            $this->users_m->update_by($data, array('id' => $id));
            $result->msg = 'مشتری مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->users_m->update_by($data, array('id' => $id));
                    }
                    $result->msg = 'مشتری های مورد نظر با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    // Add and edit 
    function edit($id = null)
    {

        // check exist
        if ($id != null) {
            $customer = $this->users_m->get_by(NULL, array('type' => 'customer', 'id' => $id, 'deleted' => 0), true);
            if (!$customer)
                $id = null;
        }


        if ($id == null) {
            // Add
            $this->userHasPermission('customers_add');
            $customer = $this->users_m->getNew();
        } else {
            // Edit
            $this->userHasPermission('customers_edit');
        }

        // Birth date gregorain
        if($customer->birth_date){
            [$year, $month, $day] = explode('/', $customer->birth_date);
            $timestamp = $this->pdate->mktime(0, 0, 0, $month, $day, $year);
            $customer->birth_date = $this->pdate->date("Y-m-d", $timestamp, false, false);
            // $customer->birth_date = $this->pdate->date("Y/m/d", $timestamp, false, true);
        }

        $customer->matched_fields = ($customer->matched_fields) ? json_decode($customer->matched_fields) :  [];
        $this->data['customer'] = $customer;

        // Bank cards
        $this->load->model('bank_cards_m');
        $this->data['bank_cards'] = $this->bank_cards_m->get_by(null, ['user_id' => $customer->id, 'deleted' => 0], false, 'priority DESC');

        // CSS & JS
        $this->data['css'] = ['assets/plugins/persian-datepicker/css/persian-datepicker.css?1'];
        $this->data['js'] = [
            'assets/plugins/persian-date/persian-date.js?1',
            'assets/plugins/persian-datepicker/js/persian-datepicker.js?1',
        ];

        $this->data['subview'] = 'admin/customer/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // save 
    function save()
    {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();


        $id = intval($this->input->post('id'));
        // check exist
        if ($id) {
            $customer = $this->users_m->get_by(NULL, array('type' => 'customer', 'id' => $id, 'deleted' => 0), true);
            if (!$customer)
                $id = 0;
        }

        $_POST['birth_date'] = englishNumber($this->input->post('birth_date'));
        if (!$id) {
            $this->form_validation->set_rules('username', 'شماره همراه', "callback_valid_username");
        }
        $this->form_validation->set_rules('first_name', 'نام', 'trim');
        $this->form_validation->set_rules('last_name', 'نام خانوادگی', 'trim');
        $this->form_validation->set_rules('email', 'ایمیل', 'trim|valid_email');
        $this->form_validation->set_rules('national_code', 'کد ملی', 'callback_validNationalCode');
        $this->form_validation->set_rules('birth_date', 'تاریخ تولد', ['trim', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]']);

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('min_length', 'حداقل تعداد کارکتر های %s ، %s کارکتر است');
        $this->form_validation->set_message('valid_email', 'لطفا %s را صحیح وارد کنید.');
        $this->form_validation->set_message('in_list', '%s را صحیح انتخاب کنید');
        $this->form_validation->set_message('validNationalCode', 'لطفا %s را صحیح وارد کنید');

        if ($this->form_validation->run() != FALSE) {
            // Birth date
            $birth_date = $this->input->post('birth_date');
            if($birth_date){
                [$year, $month, $day] = explode('/', $birth_date);
                $timestamp = $this->pdate->mktime(0, 0, 0, $month, $day, $year);
                // $birth_date_gregorian = $this->pdate->date("Y-m-d", $timestamp, false, false);
                $birth_date = $this->pdate->date("Y/m/d", $timestamp, false, true);

            }

            $national_code = $this->input->post('national_code');

            // Matched fields
            $matched_fields = [];
            if($national_code && $this->input->post('national_code_matched')){
                $matched_fields[] = 'national_code';
            }
            if($birth_date && $this->input->post('birth_date_matched')){
                $matched_fields[] = 'birth_date';
            }
            $matched_fields = json_encode($matched_fields);

            $data =  array(
                'first_name' => $this->input->post('first_name'),
                'last_name' => $this->input->post('last_name'),
                'father_name' => $this->input->post('father_name'),
                'email' => $this->input->post('email'),
                'national_code' => $national_code,
                'birth_date' => $birth_date,
                'matched_fields' => $matched_fields,
                'status' => ($this->input->post('status') == 'accept') ? 'accept' : '',
                'auth_call' => ($this->input->post('auth_call') == 1) ? 1 : 0,
            );

            //image
            $image_result = $this->uploadImage('image');
            if ($image_result->condition) {
                $source_image = $image_result->file_path;
                list($width, $height, $type, $attr) = getimagesize($source_image);
                if ($width != 300 || $height != 300) {
                    //در این حالت نیاز به برش و تغییر اندازه داریم 
                    $this->load->library('image_lib');
                    $config['source_image'] = $source_image;
                    $config['new_image'] = $source_image;
                    $config['maintain_ratio'] = FALSE;
                    $config['width'] = 300;
                    $config['height'] = 300;

                    $this->image_lib->set_enlarge(TRUE);
                    $this->image_lib->thumb($config);
                }
                $data['image'] = $source_image;
            }

            if ($id) {
                // Edit
                $this->userHasPermission('customers_edit', false, $result);
                $id = $this->users_m->save($data, $id);
            } else {
                // Add
                $this->userHasPermission('customers_add', false, $result);
                $username = trim($this->input->post('username'));
                if(strlen($username) == 10){
                    $username = '0' . $username;
                }
                $data['username'] = $username;
                $data['cell_phone'] = $username;
                // $data['activation'] = 1;
                $data['type'] = 'customer';

                $id = $this->users_m->save($data);
            }

            if($id){
                // Bank cards start
                $this->load->model('bank_cards_m');
                $db_bank_cards = $this->bank_cards_m->get_by(null, ['user_id' => $id]);
                
                $posted_cards_number = [];
                if($this->input->post('bank_cards') && is_array($this->input->post('bank_cards'))){
                    foreach ($this->input->post('bank_cards') as $card_number) {
                        if (preg_match('/^\d{16}$/', $card_number) && !in_array($card_number, $posted_cards_number)) {
                            $posted_cards_number[] = $card_number;
                        }
                    }
                }

                $restor_ids = [];
                if($db_bank_cards && $posted_cards_number){
                    foreach ($db_bank_cards as $db_key => $db_item) {
                        if(in_array($db_item->card_number, $posted_cards_number)){
                            if($db_item->deleted == 1){
                                $restor_ids[] = $db_item->id;
                            }
                            unset($db_bank_cards[$db_key]);
                            unset($posted_cards_number[array_search($db_item->card_number, $posted_cards_number)]);
                        }
                    }
                }

                // Restor
                if($restor_ids){
                    $str_ids = implode(',', $restor_ids);
                    $this->bank_cards_m->update_by(['deleted' => 0], ["id IN ($str_ids)" => null]);
                }

                // Delete
                if($db_bank_cards){
                    $ids = array_map(function($item){
                        return $item->id;
                    }, $db_bank_cards);
                    $str_ids = implode(',', $ids);
                    $this->bank_cards_m->update_by(['deleted' => 1], ["id IN ($str_ids)" => null]);
                }

                // Insert
                if($posted_cards_number){
                    $data = [];
                    $now = date('Y-m-d H:i:s');
                    foreach ($posted_cards_number as $card_numer) {
                        $data[] = [
                            'user_id' => $id,
                            'card_number' => $card_numer,
                            'created' => $now,
                        ];
                    }
                    $this->bank_cards_m->insert_batch($data);
                }

                // Bank cards end

                $result->msg = 'با موفقیت ثبت گردید';
                $result->condition = true;
                $result->url = base_url('admin/customers');
            }

        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }

    // Uplaod image
    private function uploadImage($name = NULL)
    {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {

            $this->load->library('upload');

            $output_dir = 'media/profiles/';
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . rand(1000, 9999) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = 5120; //(in kilobyte) 5 MB = 5120 KB


            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }

    // Remove image
    public function removeImage($id = 0)
    {
        $this->userHasPermission('customers_edit', false);

        $result = new stdClass();
        $result->condition = FALSE;
        $id = intval($id);
        if ($id != 0) {
            $where = array(
                'id' => $id,
                'type' => 'customer'
            );
            $user = $this->users_m->get_by(NULL, $where, TRUE);
            if ($user) {
                if ($user->image != '' && file_exists($user->image)) {
                    unlink($user->image);
                    $data = array(
                        'image' => ''
                    );
                    $this->users_m->save($data, $id);
                }
                $result->condition = TRUE;
            }
        }

        echo json_encode($result);
    }

    public function valid_username($username)
    {
        $username = trim($username);

        //required
        if (empty($username)) {
            $this->form_validation->set_message('valid_username', 'لطفا %s را وارد نمائید.');
            return false;
        }

        //regex_match
        if (!preg_match('/^9\d{9}$|^09\d{9}$/', $username)) {
            $this->form_validation->set_message('valid_username', '%s وارد شده معتبر نیست.');
            return false;
        }


        //is_unique
        if (strlen($username) == 10) {
            $username = '0' . $username;
        }
        $where = array(
            'username' => $username,
            'deleted' => 0,
            'type' => 'customer'
        );
        $user = $this->users_m->get_by('id', $where, TRUE);
        if ($user) {
            $this->form_validation->set_message('valid_username', 'این %s قبلا ثبت شده است.');
            return false;
        }

        return true;
    }

    public function validNationalCode($code) {
        return checkNationalCode($code);
    }


    public function changeStatus($status = null, $id = null)
    {
        
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('customers_edit', false, $result);

        $id = intval($id);
        $ids = [];
        if ($id > 0) {
            $ids[] = $id;
            
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $ids[] = intval($id);
                    }
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $users = $this->users_m->get_by('id', ["id IN ($str_ids)" => null, 'type' => 'customer']);
            if($users){
                $ids = array_map(function($item){
                    return $item->id;
                }, $users);

                $str_ids = implode(',', $ids);
                $status = ($status == 'accept') ? 'accept' : '';
                $this->users_m->update_by(['status' => $status], ["id IN ($str_ids)" => null]);

                if(count($ids) == 1){
                    $result->msg = 'وضعیت کاربر مورد نظر با موفقیت تغییر کرد.';
                } else {
                    $result->msg = 'وضعیت کاربران مورد نظر با موفقیت تغییر کرد.';
                }
                $result->condition = true;
            }
        }

        echo json_encode($result);
    }
}
