<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Contacts extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('contacts_m');
    }

    // Load list contacts
    function index() {
        $this->userHasPermission('contacts');
        $this->data['breadcrumb'] = array('مدیریت تماس با ما');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        $this->data['subview'] = 'admin/contact/index';

        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('contacts', false);
        echo $this->load->view('admin/contact/index', $this->data, true);
    }

    public function ajax_list() {
        $this->userHasPermission('contacts', false);

        $list = $this->contacts_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            $checkbox = '<input type="checkbox" value="' . $item->id . '">';
            $no++;
            $row = array();
            $row['checkbox'] = $checkbox;
            $row['row'] = $no;
            $row['email'] = html_escape($item->email);
            $row['cell_phone'] = $item->cell_phone;
            $row['subject'] = html_escape($item->subject);
            $row['jalali_created'] = $item->jalali_created;

            $actions = "<a title=\"مشاهده جزئیات\" class=\"btn btn-primary btn-round btn-icon\" href=\"$base_url/admin/contacts/detail/$item->id\"><i class=\"icon-eye\"></i></a> ";
            
            if (in_array('contacts_edit', $this->user_permissions)){
                //is_read
                if ($item->is_read == 1) {
                    $i_class_read = 'icon-envelope-letter';
                    $btn_class_read = 'primary';
                    $title_read = 'خوانده شده';
                    $url_read = "$base_url/admin/contacts/read/$item->id/no";
                } else {
                    $i_class_read = 'icon-envelope';
                    $btn_class_read = 'warning';
                    $title_read = 'خوانده نشده';
                    $url_read = "$base_url/admin/contacts/read/$item->id/yes";
                }
                $actions .= "<a title=\"$title_read\" class=\"btn btn-round btn-icon has-tooltip btn-$btn_class_read\" href=\"javascript: void(0)\" onclick=\"insert('$url_read','#frm-main','$base_url/admin/contacts/view','#res','#msg',false, true, 'noty' )\"><i class=\"$i_class_read\"></i></a> ";
            }
            
            if (in_array('contacts_delete', $this->user_permissions)){
                $actions .= "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/contacts/delete/$item->id','#frm-main','$base_url/admin/contacts/view','#res','delete')\"><i class=\"icon-trash\"></i></a> ";
            }
            $row['actions'] = $actions;
            $row['id'] = $item->id;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->contacts_m->count_all(),
            "recordsFiltered" => $this->contacts_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

    function delete($id = '') {
        $this->userHasPermission('contacts_delete');

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';
        $id = intval($id);
        if ($id > 0) {
            $this->contacts_m->delete($id);
            $result->msg = 'مورد انتخاب شده با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->contacts_m->delete($id);
                    }
                    $result->msg = 'موارد انتخاب شده با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    // Reading
    function read($id = null, $status = 'yes') {
        $this->userHasPermission('contacts_edit');

        if ($status == 'yes') {
            $data = array(
                'is_read' => '1'
            );
        } else {
            $data = array(
                'is_read' => '0'
            );
        }

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا';

        $id = intval($id);
        if ($id != 0) {

            $this->contacts_m->update($data, $id);
            $message = ($status == 'yes') ? 'در وضعیت خوانده شده قرار گرفت' : 'در وضعیت خوانده نشده قرار گرفت';
            $result->msg = $message;
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        if ($id != 0) {
                            $this->contacts_m->update($data, $id);
                        }
                    }
                    $message = ($status == 'yes') ? 'در وضعیت خوانده شده قرار گرفتند' : 'در وضعیت خوانده نشده قرار گرفتند';
                    $result->msg = $message;
                    $result->condition = true;
                }
            }
        }

        //تعداد پیام های خوانده نشده
        $new_contact = $this->contacts_m->get_by('count(id) as new_contact', array('is_read' => '0'), true)->new_contact;
        if ($new_contact == 0) {
            $result->script = '$(".contact-count").addClass("hidden");';
        } else {
            $result->script = '$(".contact-count").html("' . $new_contact . '");$(".contact-count").removeClass("hidden");';
        }


        echo json_encode($result);
    }

    // Detail
    function detail($id = null) {
        $this->userHasPermission('contacts');

        $id = intval($id);
        $contact = $this->contacts_m->get($id, true);
        $this->data['contact'] = $contact;


        if ($contact && !$contact->is_read) {
            //وضعیت را به خوانده شده تغییر می دهیم
            $this->contacts_m->save(array('is_read' => '1'), $id);
        }

        //تعداد پیام های خوانده نشده
//        $new_contact = $this->contacts_m->get_by('count(id) as new_contact', array('is_read' => '0'), true)->new_contact;
//        if ($new_contact == 0) {
//           $this->data['script'] = '$(".contact-count").addClass("hidden");';
//        } else {
//          $this->data['script'] = '$(".contact-count").html("' . $new_contact . '");$(".contact-count").removeClass("hidden");';
//        }

        $this->data['subview'] = 'admin/contact/detail';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // خلاصه متن
    function textSummary($text) {
        $min_length = 200;
        $max_length = 220;
        $text_length = strlen($text);
        if ($text_length > $min_length) {
            for ($i = $min_length; $i < $max_length; $i++) {
                if (substr($text, $i, 1) == ' ') {
                    return substr($text, 0, $i) . ' ...';
                }
            }
            return substr($text, 0, $min_length) . ' ...';
        }

        return $text;
    }

    //ارسال ایمیل
    // Send admin reply as an email
    function save() {
        $this->userHasPermission('contacts_edit');

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $result->csrf = $this->security->get_csrf_hash();

        $id = intval($this->input->post('id'));
        $contact = $this->contacts_m->get_by(null, array('id'=>$id), true);
        if($contact){
            $answer = trim($this->input->post('answer'));
            $data = array(
                'answer' => $answer
            );
            $this->contacts_m->save($data, $contact->id);

            // Check request send email
            if($answer && $this->input->post('send_email') === '1'){
                $this->load->model('settings_m');
                $fields = array( 'site_name', 'site_name_en', 'logo');
                $settings = $this->settings_m->getSettings($fields);

                $this->data['contact'] = $contact;
                $this->data['admin_reply'] = $answer;
                $email_body = $this->load->view('admin/contact/email_template', $this->data, TRUE);
                $this->load->library('frontend_general');
                $this->frontend_general->sendEmail($contact->email, $email_body, $contact->name, $contact->subject, $settings->site_name, $settings->site_name_en, $settings->logo);
            }

            $result->msg = 'با موفقیت ثبت گردید.';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/contacts');
        }
        echo json_encode($result);

    }

}

?>
