<?php

/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');

class Order extends Frontend_Controller {

    function __construct() {
        parent::__construct();

        $this->load->library('frontend_general');
        $this->load->model('orders_m');
        $this->load->model('order_cards_m');
        $this->load->model('products_m');
        $this->load->model('categories_m');
        $this->load->model('cards_m');
        $this->load->model('settings_m');
    }

    public function save() {
        //save
        $message = 'خطا در عملیات';
        $condition = false;

        // چک می‌کنیم که کاربر مجاز به ثبت سفارش می‌باشد
        $access_buy = accessToBuy($this->user_login, $this->settings);
        if($access_buy->condition == false){
            redirect('home');
        }

        // چک کردن وجود محصول
        $product_id = intval($this->input->post('product_id'));
        $where = array(
            'id' => $product_id,
            'publish' => 1,
            'is_exists' => 1,
            'deleted' => 0,
        );
        $product = $this->products_m->get_by('id, category_id, manual, currency, max_qty, min_qty', $where, true);
        if (!$product) {
            $message = 'محصول انتخابی یافت نشد.';
            $this->session->set_flashdata('order_message', $message);
            redirect('home');
        }

        // گرفتن فیلد‌های دسته‌بندی برای اعتبارسنجی
        $category = $this->categories_m->get_by('fields', ['id' => $product->category_id], true);
        $category_fields = ($category) ? categoryFields($category->fields, $this->user_login) : [];

        // جمع مبلغ فاکتور
        $posted_price = intval($this->input->post('price'));
        $gateway = $this->input->post('gateway');

        if(!$this->user_login){
            $this->form_validation->set_rules('cell_phone', 'شماره همراه', ['required', 'regex_match[/^9\d{9}$|^09\d{9}$/]']);
        }

        foreach ($category_fields as $field) {
            $field->validation = ($field->validation) ? "trim|$field->validation" : "trim";
            $this->form_validation->set_rules($field->name, $field->title, $field->validation);
        }

        $this->form_validation->set_rules('product_id', 'محصول', "required");
        $this->form_validation->set_rules('qty', 'تعداد', "required");


        if($gateway == 'card2card' && $posted_price){
            $_POST['transfer']['date'] = englishNumber($this->input->post('transfer[date]'));
            $_POST['transfer']['reference'] = englishNumber($this->input->post('transfer[reference]'));
            $this->form_validation->set_rules('transfer[reference]', 'شماره پیگیری تراکنش', "trim|required|min_length[5]|regex_match[/^[a-zA-Z0-9]+$/]");
            $this->form_validation->set_rules('transfer[card]', 'شماره کارت', "trim|required|regex_match[/^\d{16}$/]");
            $this->form_validation->set_rules('transfer[date]', 'تاریخ واریز', array('trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]'));
            $this->form_validation->set_rules('transfer[clock]', 'ساعت واریز', array('trim', 'required', 'regex_match[/^([01]?\d|2[0-3]):([0-5]?\d)$/]'));
        }

        if(intval($this->session->userdata('user_submit_count')) > $this->captcha_limit){
            $captcha = $this->session->userdata('captcha');
            $this->form_validation->set_rules('captcha', 'کد امنیتی', "required|callback_is_equal[$captcha]");
        }

        $this->form_validation->set_message('required', 'وارد کردن %s اجباری است.');
        $this->form_validation->set_message('exact_length', 'تعداد رقم های %s باید %s رقم باشد.');
        $this->form_validation->set_message('regex_match', '%s صحیح نیست.');
        $this->form_validation->set_message('valid_email', '%s معتبر نیست.');
        $this->form_validation->set_message('min_length', 'تعداد رقم های %s حداقل باید %s رقم باشد.');
        $this->form_validation->set_message('is_equal', 'لطفا %s را صحیح وارد کنید');
        $this->form_validation->set_message('validNationalCode', 'لطفا %s را صحیح وارد کنید');

        if ($this->form_validation->run()) {
            $first_name = $this->security->xss_clean(strtolower($this->input->post('first_name')));
            $last_name = $this->security->xss_clean(strtolower($this->input->post('last_name')));
            $national_code = strtolower($this->input->post('national_code'));
            $email = strtolower($this->input->post('email'));

            if($this->user_login){

                // اینجا چک میکنیم که ایمیل دامنه ایمیل مجاز باشد
                if($email){
                    $this->load->model('blocks_m');
                    if($this->blocks_m->isEmailBlacklisted($email)){
                        $this->blocks_m->smartBlockUsers($this->user_login->id, 'order', $email);

                        $message = 'شما از ایمیل غیر مجاز استفاده کردید و بلاک شدید. لطفا موضوع را از طریق صفحه تماس با ما پیگیری کنید.';
                        $this->session->set_flashdata('frontend_error', $message);
                        redirect('users/logout');
                    }
                }

                $cell_phone = $this->user_login->cell_phone;
                $user_id = $this->user_login->id;

                $data = [];
                if($email && !$this->user_login->email) $data['email'] = $email;
                if($first_name && !$this->user_login->first_name) $data['first_name'] = $first_name;
                if($last_name && !$this->user_login->last_name) $data['last_name'] = $last_name;
                if($national_code && !$this->user_login->national_code) $data['national_code'] = $national_code;
                if($data){
                    $this->users_m->save($data, $user_id);
                }
            }else{
                $cell_phone = $this->input->post('cell_phone');
                if(strlen($cell_phone) == 10){
                    $cell_phone = '0' . $cell_phone;
                }

                //چک می کنیم با این شماره همراه قبلا کاربری ثبت شده است
                $where = [
                    'username' => $cell_phone,
                    'type' => 'customer',
                    'deleted' => 0
                ];
                $user = $this->users_m->get_by('id', $where, true);
                if($user){
                    $user_id = $user->id;
                }else{
                    $data = [
                        'username' => $cell_phone,
                        'cell_phone' => $cell_phone,
                        'type' => 'customer',
                        'deleted' => 0,
                        'block' => 0,
                        'activation' => 0,
                    ];
                    $user_id = $this->users_m->save($data);
                    if(!$user_id){
                        $message = 'خطای در ثبت شماره همراه شما رخ داده است. لطفا با مدیر سایت تماس بگیرید.';
                        $this->session->set_flashdata('order_message', $message);
                        redirect('home');
                    }
                }
            }
            
            $qty = intval($this->input->post('qty'));
            if($qty < 1){
                $qty = 1;
            }

            // Min qty
            if ($qty < $product->min_qty) {
                $message = "حداقل تعداد بایستی {$product->min_qty} باشد.";
                $this->session->set_flashdata('order_message', $message);
                redirect('home');
            }

            // تعداد کارت های قابل فروش فعلی را چک کن
            $cards = $this->products_m->getProductCards($product_id, $qty);
            if(!$cards){
                $message = 'متاسفانه محصول درخواستی شما به اتمام رسید.';
                $this->session->set_flashdata('order_message', $message);
                redirect('home');
            }

            // Max qty
            $product->max_qty = intval($product->max_qty);
            $max_qty = ($cards && $product->max_qty) ? min([count($cards), $product->max_qty]) : count($cards);
            if ($qty > $max_qty) {
                $message = 'متاسفانه تعداد درخواستی شما به اتمام رسید، می توانید مجددا با تعداد کمتر خرید نمائید.';
                $this->session->set_flashdata('order_message', $message);
                redirect('home');
            }

            

            // چک کردن قیمت ارسالی با محاسبه شده
            $prices = $this->products_m->getProductPrices($product_id);
            $order_price = 0; // مبلغ نهایی فاکتور
            $pureTotal = 0; // مبلغ قابل پرداخت
            $card_sell_price = $card_currency_sell_price = $card_price =  0;
            $currency = $product->currency;
            if ($prices) {
                foreach ($prices as $price) {
                    if ($qty >= $price->from_qty && ($qty <= $price->to_qty || $price->to_qty == '')) {
                        $pureTotal = ($currency == 'tooman') ? $qty * $price->sell_price : $qty * currency_to_tooman($price->sell_price, $this->settings->rate->$currency, $this->settings->round_price);
                        $card_sell_price = ($currency == 'tooman') ? $price->sell_price : currency_to_tooman($price->sell_price, $this->settings->rate->$currency, $this->settings->round_price);
                        $card_currency_sell_price = ($currency == 'tooman') ? 0 : $price->sell_price;
                        $card_price = ($currency == 'tooman') ? $price->price : currency_to_tooman($price->price, $this->settings->rate->$currency, $this->settings->round_price);
                        break;
                    }
                }
            }

            // Coupon
            $coupon_code = $this->input->post('coupon');
            $coupon = null;
            if($coupon_code){
                $result_coupon = ($coupon_code) ? $this->checkCoupon($coupon_code, $email, $cell_phone) : null;
                if($result_coupon && $result_coupon->condition){
                    $coupon = $result_coupon->coupon;
                }
            }

            $coupon_id = $coupon_discount = 0;
            if($coupon){
                if($coupon->minimum == 0 || ($coupon->minimum > 0 && $pureTotal >= $coupon->minimum)){
                    if(count($coupon->product_ids) == 0 || (count($coupon->product_ids) > 0 && in_array($product_id, $coupon->product_ids))){
                        $coupon->amount = $coupon->amount * 1;
                        if($coupon->discount_type == 'price'){
                            if($coupon->amount > $pureTotal){
                                $coupon->amount = $pureTotal;
                            }
                            $coupon_discount = ($coupon->amount > $pureTotal) ? $pureTotal : $coupon->amount;
                        }else{
                            $coupon_discount = round($pureTotal * $coupon->amount / 100);
                        }
                        $pureTotal = $pureTotal - $coupon_discount;
                        $coupon_id = $coupon->id;
                    }
                }
            }

            $order_price = $pureTotal;

            // مبلغی که از کیف پول استفاده می شود
            $use_wallet_amount = 0;
            if($order_price && $this->user_login && $this->user_login->credit && $this->input->post('use_wallet') == 1){
                $pureTotal = ($this->user_login->credit  >= $order_price ) ? 0 : $order_price - $this->user_login->credit;
                $use_wallet_amount = $order_price - $pureTotal;
            }

            if ($pureTotal != $posted_price) {
                $message = 'مبلغ محصول انتخابی شما تغییر کرده است. لطفا دوباره نسبت به سفارش فاکتور اقدام کنید.';
                $this->session->set_flashdata('order_message', $message);
                redirect('home');
            }

            // اگر مبلغ قابل پرداخت صفر بود
            if($pureTotal == 0){
                $gateway = '';
            }

            // چک کردن شماره کارت بانکی که می‌خواهد با آن پرداخت کند
            if(
                $this->user_login &&
                $pureTotal > 0 &&
                $gateway != 'card2card' &&
                in_array('bank_card', $this->settings->verify_when_buy)
            ){
                $card_number = $this->input->post('card_number');
                if (!preg_match('/^\d{16}$/', $card_number)) {
                    $message = 'شماره کارت بانکی صحیح نبود.';
                    $this->session->set_flashdata('order_message', $message);
                    redirect('home');
                }

                $this->load->model('bank_cards_m');
                $bank_card = $this->bank_cards_m->get_by('id, card_number', [
                    'user_id' => $this->user_login->id,
                    'card_number' => $card_number,
                    'deleted' => 0
                ], true);

                if(!$bank_card){
                    $message = 'شماره کارت بانکی صحیح نبود.';
                    $this->session->set_flashdata('order_message', $message);
                    redirect('home');
                }
            }

            $this->load->library('pdate');
            $jalali_created = $this->pdate->date('Y/m/d H:i:s');

            // Pending
            $product->manual = intval($product->manual);
            $pending = 1;
            if(
                $gateway != 'card2card' && 
                (
                    $product->manual == 0 || 
                    ($product->manual == 2 && $this->user_login && $this->user_login->status == 'accept')
                )
                
            ){
                $pending = 0;
            }

            // Transfer image
            if($gateway == 'card2card'){
                $transfer_image = '';
                $image_result = $this->uploadImageTransaction('image');
                if ($image_result->condition) {
                    $transfer_image = $image_result->file_path;
                } else {
                    // $image_error = $image_result->error
                }
            }

            // Fields
            $fields = [];
            foreach ($category_fields as $field) {
                if($field->statics_key == 'email'){
                    continue;
                }
                $value = $this->security->xss_clean($this->input->post($field->name));
                if($field->statics_key){
                    if($field->statics_key == 'national_code' && empty($value) && $this->user_login && $this->user_login->national_code){
                        $value = $this->user_login->national_code;
                    }
                    $fields[$field->statics_key] = [
                        'value' => $value,
                        'ordering' => $field->ordering,
                    ];
                } else {
                    $fields['dynamic'][] = [
                        'title' => $field->title,
                        'value' => $value,
                        'ltr' => $field->ltr,
                        'ordering' => $field->ordering,
                    ];
                }
            }

            //تولید کد پیگیری
            do {
                $tracking_code = rand(99999999, 10000000);
                $order = $this->orders_m->get_by('id', array('tracking_code' => $tracking_code));
            } while ($order);

            //ثبت سفارش
            $data = array(
                'user_id' => $user_id,
                'tracking_code' => $tracking_code,
                'paid' => 0,
                'price' => $order_price,
                'coupon_id' => $coupon_id,
                'coupon_discount' => $coupon_discount,
                'reading' => 0,
                'email' => $email,
                'cell_phone' => $cell_phone,
                'jalali_created' => $jalali_created,
                'pending' => $pending,
                'ip' => $this->input->ip_address(),
                'card2card' => ($gateway=='card2card') ? 'pending' : '',
                'fields' => json_encode($fields, JSON_UNESCAPED_UNICODE),
            );

            $save_result = $this->orders_m->saveWithTrans($data);
            if ($save_result->status == 'success') {
                $order_id = $save_result->order_id;

                // Captcha count
                $count = intval($this->session->userdata('user_submit_count')) + 1;
                $this->session->set_userdata('user_submit_count', $count);

                // این کارت ها را موقتا روی این کاربر قفل کن که قابل فروش به دیگران نباشد
                $minutes = $this->settings->inaccess_minutes;
                if(in_array($gateway, $this->data['dollar_gateways']) && $minutes < 60){
                    $minutes = 60;// برای پرداخت‌های کریپتو زمان بیشتری نیازه
                }

                $inaccess_date = date('Y-m-d H:i:s', strtotime(" +{$minutes} minute"));
                $now = date('Y-m-d H:i:s');
                
                $cards_data = $order_cards_data = array();
                foreach ($cards as $card) {
                    $cards_data[] = array(
                        'id' => $card->id,
                        'deactive_date' => $inaccess_date,
                        'order_id' =>  $order_id
                    );
                    
                    $order_cards_data[] = array(
                        'order_id' => $order_id,
                        'card_id' => $card->id,
                        'price' => $card_price,
                        'sell_price' => $card_sell_price,
                        'currency_sell_price' => $card_currency_sell_price,
                        'currency_rate' => ($product->currency == 'tooman') ? 0 : $this->settings->rate->$currency,
                        'currency' => $product->currency
                    );
                }
                $this->cards_m->update_batch($cards_data, 'id');
                $this->order_cards_m->insert_batch($order_cards_data);

                if($gateway == 'card2card'){
                    $this->load->model('transactions_m');

                    // ثبت تراکنش برای کارت به کارت
                    // Transfer time
                    [$year, $month, $day] = explode('/', $this->input->post('transfer[date]'));
                    [$hour, $minute] = explode(':', $this->input->post('transfer[clock]'));
                    $second = 0;
                    $temp = $this->pdate->mktime($hour, $minute, $second, $month, $day, $year);
                    $transfer_date = $this->pdate->date("Y-m-d H:i:s", $temp, false, false);
        
                    $card2card_info = (object)[
                        'use_wallet_amount' => $use_wallet_amount,
                        'amount' => $pureTotal,
                        'reference' => $this->input->post('transfer[reference]'),
                        'detail' => json_encode([
                            'customer_card' => $this->input->post('transfer[card]'),
                            'transfer_date' => $transfer_date,
                            'image' => $transfer_image,
                            'description' => $this->security->xss_clean($this->input->post('transfer[description]')),
                        ], JSON_UNESCAPED_UNICODE),
                    ];
                    
                    $pay_result = $this->transactions_m->payOrderWithWallet($order_id, $this->user_login, null, $card2card_info);
                    if($pay_result->success){
                        if(isset($pay_result->new_credit)){
                            $this->user_login->credit = $pay_result->new_credit;
                            $this->data['user_login']->credit = $pay_result->new_credit;
                        }
                    } else {
                        $this->session->set_flashdata('order_message', $pay_result->error);
                        redirect('home');
                    }
                }
                
                $condition = TRUE;
            } else {
                $message = "<p>$save_result->message</p>";
                $this->session->set_flashdata('order_message', $message);
                redirect('home');
            }

        } else {
            $message = validation_errors();
            $this->session->set_flashdata('order_message', $message);
            redirect('home');
        }

        if ($condition) {
            if(!$gateway && $pureTotal > 0){
                $this->session->set_flashdata('order_message', 'درگاهی انتخاب نشده است.');
                redirect('home');
            }
           
            $pay_url = "pay/request/$order_id/";
            if($gateway){
                $pay_url .= "$gateway/";
            }
            $pay_url .= '?';
            if($use_wallet_amount && $gateway != 'card2card'){
                $pay_url .= 'use_wallet=1&';
            }
            if(isset($bank_card)){
                $pay_url .= "card=$bank_card->card_number&";
            }
            $pay_url = trim($pay_url, '&');
            $pay_url = trim($pay_url, '/?');

            if(in_array('cell_phone', $this->settings->verify_when_buy) && !$this->user_login){
                $this->session->set_userdata('last_page', $pay_url);
                //ارسال کد تایید
                $this->sendVerifyCode($cell_phone);

                // اطلاعات کاربر را در یک سشن می‌ریزم که بعد از تایید شماره همراه در صورتی که اظلاعاتش قبلا ثبت نشده بود آن را رد دیتابیس ثبت کنیم
                $this->session->set_userdata('order_user_info', (object)[
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'email' => $email,
                    'national_code' => $national_code,
                ]);
                redirect("verify");
            } else {
                redirect($pay_url);
            }
        } else {
            $this->session->set_flashdata('order_message', $message);
            redirect('home');
        }
    }

    // For captcha
    function is_equal($str, $value) {
        return (strtoupper($str) === strtoupper($value));
    }

    //apply coupon
    public function applyCoupon(){
        if(!$this->user_login){
            $this->form_validation->set_rules('cell_phone', 'شماره همراه', ['required', 'regex_match[/^9\d{9}$|^09\d{9}$/]']);
        }
        $this->form_validation->set_rules('coupon', 'کد تخفیف', 'trim|required');

        // email
        // $required =  ($this->settings->process_checkbox == 'email' || $this->settings->process_checkbox == 'email&cellphone') ? '|required' : '';
        // $this->form_validation->set_rules('email', 'ایمیل', "trim{$required}|valid_email");

        $this->form_validation->set_message('required', 'وارد کردن %s اجباری است.');
        $this->form_validation->set_message('exact_length', 'تعداد رقم های %s باید %s رقم باشد.');
        $this->form_validation->set_message('regex_match', '%s صحیح نیست.');
        $this->form_validation->set_message('valid_email', '%s معتبر نیست.');

        if ($this->form_validation->run()) {
            $code = $this->input->post('coupon');
            $email = ''; //$this->input->post('email');

            if($this->user_login){
                $cell_phone = $this->user_login->cell_phone;
            }else{
                $cell_phone = $this->input->post('cell_phone');
                if(strlen($cell_phone) == 10){
                    $cell_phone = '0' . $cell_phone;
                }
            }
            
            $result = $this->checkCoupon($code, $email, $cell_phone);
            if($result->condition){
                unset($result->coupon->id);
                unset($result->coupon->code);
                unset($result->coupon->title);
                unset($result->coupon->publish);
                unset($result->coupon->deleted);
                unset($result->coupon->count);
                unset($result->coupon->start_date);
                unset($result->coupon->end_date);
            }
        }else{
            $result = new stdClass();
            $result->condition = FALSE;
            $result->message = validation_errors();
        }

        $result->csrf = $this->security->get_csrf_hash();
        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    }

    public function validNationalCode($code) {
        return checkNationalCode($code);
    }
}

?>
