<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Notices extends Frontend_Controller {

    function __construct() {
        parent::__construct();
    }

    public function save() {
        $result = new stdClass();
        $result->condition = FALSE;
        $result->csrf = $this->security->get_csrf_hash();

        if($this->input->post('notice_ids') && $this->notices->unseen_notice_ids){
            $posted_notice_ids = explode(',', $this->input->post('notice_ids'));

            // مجازها همان مشترک‌ها هستند
            $valid_notice_ids = array_intersect($this->notices->unseen_notice_ids, $posted_notice_ids);
            
            if($valid_notice_ids){
                // Reindex
                $valid_notice_ids = array_values($valid_notice_ids);

                $result->condition = true;
                $result->notice_ids = $valid_notice_ids;

                // echo json_encode($result, JSON_UNESCAPED_UNICODE);
                // die();

                $this->notices->seen_notice_ids = array_merge($this->notices->seen_notice_ids, $valid_notice_ids);
                $this->notices->seen_notice_ids = array_unique($this->notices->seen_notice_ids);
                
                // Save to cookie
                $value = implode(',', $this->notices->seen_notice_ids);
                set_cookie('seen_notice_ids', $value, 3600 * 24 * 30);


                // Save to db
                if($this->user_login){
                    $now = date('Y-m-d H:i:s');
                    $data = [];
                    foreach ($valid_notice_ids as $notice_id) {
                        if(!in_array($notice_id, $this->notices->db_seen_notice_ids)){
                            $data[] = [
                                'notice_id' => $notice_id,
                                'user_id' => $this->user_login->id,
                                'created' => $now,
                            ];
                        }
                    }

                    if($data){
                        $this->load->model('seen_notices_m');
                        $this->seen_notices_m->insert_batch($data);
                    }
                }

                
            }
        }
        

        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    }
}

?>