<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Home extends Frontend_Controller {

    function __construct() {
        parent::__construct();
    }

    public function index($object = null, $value = null) {
        $this->load->model('categories_m');
        $this->load->model('products_m');

        // CSS & JS
        $this->data['css'] = [];
        $this->data['js'] = [];

        $product_id = 0;
        $product_slug = '';
        $category_id = 0;
        $category_slug = '';
        $step = 1; // Current step

        if($object == 'category'){
            if(is_numeric($value)){
                $category_id = intval($value);
            } else {
                $category_slug = urldecode($value);
            }
            $step = 2;
        } elseif($object == 'product'){
            if(is_numeric($value)){
                $product_id = intval($value);
            } else {
                $product_slug = urldecode($value);
            }
            $step = 3;
        }

        $is_spa = $this->settings->buy_steps->is_spa;
        $selected_product = null;
        $selected_category = null;

        if($is_spa){
            // List of categories
            $categories = $this->categories_m->getCategories(false);

            $category_keys = []; // key = category_id & value = category_key
            if($categories){
                foreach ($categories as $key => $item) {
                    // آیا دسته شامل حداقل یک محصول موجود هست یا خیر
                    $categories[$key]->has_product = 0; 
    
                    // محصولات دسته
                    $categories[$key]->products = []; 
    
                    $category_keys[$item->id] = $key;
                }
    
                // Products
                $products = $this->products_m->getProducts((object)[
                    'rate' => $this->settings->rate,
                    'round_price' => $this->settings->round_price,
                ]);
                if($products){
                    foreach($products as $product){
                        // Check category
                        if(!isset($category_keys[$product->category_id])){
                            continue;
                        }
                        $category_key = $category_keys[$product->category_id];
    
                        // Add to category
                        $categories[$category_key]->products[] = $product;
                        if($product->is_exists){
                            $categories[$category_key]->has_product = 1;
                        }
    
                        // Selected product
                        if(($product_id && $product->id == $product_id) || ($product_slug && $product->slug == $product_slug)){
                            // Canonical and meta
                            $temp = $this->products_m->get_by('meta_title, meta_description, front_description AS description', ['id' => $product->id], true);
                            $product->meta_title = $temp->meta_title;
                            $product->meta_description = $temp->meta_description;
                            $product->description = $temp->description;
    
                            $this->data['meta_title'] = ($product->meta_title) ? $product->meta_title : $product->title;
    
                            if($product->meta_description){
                                $this->data['meta_description'] =  $product->meta_description;
                            }
    
                            if($product->image && file_exists($product->image)){
                                $this->data['meta_image'] = base_url($product->image);
                            } elseif($product->large_image && file_exists($product->large_image)){
                                $this->data['meta_image'] = base_url($product->large_image);
                            } elseif($product->category_image && file_exists($product->category_image)){
                                $this->data['meta_image'] = base_url($product->category_image);
                            }
    
                            $this->data['canonical'] = ($product->slug) ?  base_url("product/$product->slug") : base_url("product/$product->id");
    
                            $selected_product = $product;
                        }
    
                    }
                }
    
                //  آنهای که محصول ندارند بروند ته لیست
                $exists_categories = [];
                $not_exists_categories = [];
                foreach ($categories as $key => $category) {
                    
    
                    if($category->has_product){
                        // حداقل یک محصول موجود وجود را دارد
                        // فیلد های سفارش را بررسی می کنیم
                        
                        $category->fields = categoryFields($category->fields, $this->user_login);
                        
                        $exists_categories[] = $category;
    
                    } else {
                        // هیچ محصول موجودی وجود ندارد
                        // نیاز نیست فیلد های سفارش را بررسی کنیم
                        $category->fields = [];
                        
                        $category->products = [];
                        $not_exists_categories[] = $category;
                    }
    
                    if($selected_product && $selected_product->category_id == $category->id){
                        $selected_product->category_fields = $category->fields;
                    }
    
                    // Selected category
                    if(($category_id && $category->id == $category_id) || ($category_slug && $category->slug == $category_slug)){
                        // Canonical and meta
                        $temp = $this->categories_m->get_by('meta_title, meta_description', ['id' => $category->id], true);
                        $category->meta_title = $temp->meta_title;
                        $category->meta_description = $temp->meta_description;
    
                        $this->data['meta_title'] = ($category->meta_title) ? $category->meta_title : $category->title_fa;
    
                        if($category->meta_description){
                            $this->data['meta_description'] =  $category->meta_description;
                        }
    
                        if($category->image && file_exists($category->image)){
                            $this->data['meta_image'] = base_url($category->image);
                        } elseif($category->large_image && file_exists($category->large_image)){
                            $this->data['meta_image'] = base_url($category->large_image);
                        }
    
                        $this->data['canonical'] = ($category->slug) ?  base_url("category/$category->slug") : base_url("category/$category->id");
    
                        // Check status
                        if($category->has_product){
                            $selected_category = $category;
                        } else {
                            // CSS & JS
                            array_push($this->data['css'], 'assets/plugins/noty/css/flat.css');
                            array_push($this->data['js'], 'assets/plugins/noty/js/noty/packaged/jquery.noty.packaged.min.js');
         
                            $this->data['message_not_exists_ptoduct'] = "در حال حاضر در دسته $category->title_fa تمامی محصولات ناموجود هستند.";
                        }
    
                    }
                }
                $categories = array_merge($exists_categories, $not_exists_categories);
                unset($exists_categories);
                unset($not_exists_categories);
            }

            $this->data['categories'] = $categories;
        }

        // Is not spa
        else {
            // List of categories
            if($step == 1){
                $categories = $this->categories_m->getCategories(true);
                $this->data['categories'] = $categories;

                // Canonical and meta 
                $this->data['canonical'] = base_url();
            }

            // List of products or category page
            elseif($step == 2){
                $category = $this->categories_m->getDetail($category_id, $category_slug);

                if(!$category){
                    redirect('errors/error404');
                }
                $selected_category = $category ;

                // Products
                $products = $this->products_m->getProducts((object)[
                    'rate' => $this->settings->rate,
                    'round_price' => $this->settings->round_price,
                    'category_id' => $category->id
                ]);

                $category->products = $products;

                $categories = [$category];
                $this->data['categories'] = $categories;

                // Canonical and meta
                $this->data['meta_title'] = ($category->meta_title) ? $category->meta_title : $category->title_fa;

                if($category->meta_description){
                    $this->data['meta_description'] =  $category->meta_description;
                }

                if($category->image && file_exists($category->image)){
                    $this->data['meta_image'] = base_url($category->image);
                } elseif($category->large_image && file_exists($category->large_image)){
                    $this->data['meta_image'] = base_url($category->large_image);
                }

                $this->data['canonical'] = ($category->slug) ?  base_url("category/$category->slug") : base_url("category/$category->id");


            }

            // Order and pay or product page
            elseif($step == 3){
                $product = $this->products_m->getDetail($product_id, $product_slug, $this->settings->rate, $this->settings->round_price);
                if(!$product){
                    redirect('errors/error404');
                }
                
                $product->category_fields = categoryFields($product->category_fields, $this->user_login);
                $selected_product = $product;

                // Canonical and meta
                $this->data['meta_title'] = ($product->meta_title) ? $product->meta_title : $product->title;

                if($product->meta_description){
                    $this->data['meta_description'] =  $product->meta_description;
                }

                if($product->image && file_exists($product->image)){
                    $this->data['meta_image'] = base_url($product->image);
                } elseif($product->large_image && file_exists($product->large_image)){
                    $this->data['meta_image'] = base_url($product->large_image);
                } elseif($product->category_image && file_exists($product->category_image)){
                    $this->data['meta_image'] = base_url($product->category_image);
                }

                $this->data['canonical'] = ($product->slug) ?  base_url("product/$product->slug") : base_url("product/$product->id");

            }

        }

        $this->data['selected_product'] = $selected_product;
        $this->data['selected_category'] = $selected_category;

        // تعیین افقی یا عمودی بودن باکس محصول و دسته بندی در دسکتاپ
        $vertical_layout = $this->settings->product_ui->vertical_layout;

        // تعیین افقی یا عمودی بودن باکس محصول و دسته بندی در موبایل
        $mobile_vertical_layout = $this->settings->product_ui->mobile_vertical_layout;

        // تعداد دسته بندی ها/ محصولات در هر ردیف در حالت دسکتاپ
        $count_per_row = $this->settings->product_ui->count_per_row;
        if($count_per_row == 2){
            $appropriate_col = 6;
        }else if($count_per_row == 3){
            $appropriate_col = 4;
        }else if($count_per_row == 6){
            $appropriate_col = 2;
        }else{
            $appropriate_col = 3;
        }
        
        $image_size = (($vertical_layout && !$this->is_mobile) || ($mobile_vertical_layout && $this->is_mobile)) ? 'large' : 'small';

        $this->data['vertical_layout'] = $vertical_layout;
        $this->data['mobile_vertical_layout'] = $mobile_vertical_layout;
        $this->data['count_per_row'] = $count_per_row;
        $this->data['appropriate_col'] = $appropriate_col;
        $this->data['image_size'] = $image_size;

        // dd([
        //     '$selected_product'=> $selected_product,
        //     '$selected_category'=> $selected_category,
        // ]);

        // End step
        if($is_spa || (!$is_spa && $step == 3)){
            // Prices
            $product_id = (!$is_spa && $step == 3) ? $selected_product->id : 0;
            $prices = $this->products_m->getAllProductsPrices($product_id);
            if($prices){
                foreach($prices as $item){
                    if($item->product_currency == 'tooman'){
                        $item->price *= 1;
                        $item->sell_price *= 1;
                    } else {
                        $currency = $item->product_currency;
                        $item->price = currency_to_tooman($item->price, $this->settings->rate->$currency, $this->settings->round_price);
                        $item->sell_price = currency_to_tooman($item->sell_price, $this->settings->rate->$currency, $this->settings->round_price);
                    }
                }
            }
            $this->data['prices'] = $prices;

            $this->gateways();

            // Rules page
            $this->load->model('pages_m');
            $where = array('publish'=>1, 'is_rule'=>1);
            $this->data['rules_page'] = $this->pages_m->get_by('id, title, content', $where, true);

            // Captcha generator
            if (intval($this->session->userdata('user_submit_count')) > $this->captcha_limit){
                $this->data['captcha_image'] = $this->frontend_general->create_captcha();
            }

            $this->data['settings']->show_gift_box = (in_array($this->settings->show_gift_box, ['buy', 'both'])) ? true : false;
    
            $this->data['access_buy'] = accessToBuy($this->user_login, $this->settings);
        }

        // Slider
        if($step == 1){
            $this->load->model('sliders_m');
            $sliders = $this->sliders_m->getForShow($this->is_mobile);
            if($sliders){
                $this->data['sliders'] = $sliders;
            }
        }

        // Site description
        if($step == 1){
            $this->data['site_description'] = $this->settings_m->getSingle('site_description');
        }

        // Canonical and meta 
        if(!isset($this->data['canonical'])) {
            $this->data['canonical'] = base_url();
        }

        $this->data['is_spa'] = $is_spa;
        $this->data['step'] = $step;
        $this->data['content'] = 'home';
        if(!$is_spa){
            $this->data['step_html'] = $this->load->view("steps/step_{$step}", $this->data, true);
        }
        $this->load->view('_layout_main', $this->data);
    }

    // Load captcha ajax
    function create_captcha() {
        $captcha_image = $this->frontend_general->create_captcha();
        echo $captcha_image;
    }

    //for captcha
    function is_equal($str, $value) {
        return (strtoupper($str) === strtoupper($value));
    }

    public function getProductInfo($product_id = null){
        $this->load->model('products_m');
        $product_id = intval($product_id);

        $where = array(
            'id' => $product_id,
            'publish' => 1,
            'deleted' => 0
        );
        $product = $this->products_m->get_by('front_description', $where, true);
        if ($product) {
            if($product->front_description){
                echo "<div>$product->front_description</div>";
            }else{
                echo '<p>توضیحات برای این محصول ثبت نشده است</p>';
            }
        }else{
            echo '<p>اطلاعاتی یافت نشد</p>';
        }
    }
}

?>
