<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes with
| underscores in the controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['admin'] = "admin/dashboard";
$route['admin-([a-zA-Z0-9]+)'] = 'admin/users/login/$1';

$route['admin/transactions/add/(\d.*)'] = 'admin/transactions/edit/0/$1';

$route['default_controller'] = 'home';
$route['404_override'] = 'errors/error404';
$route['translate_uri_dashes'] = FALSE;
$route['contact-us'] = 'pages/contact';
$route['page/(\d.*)'] = 'pages/detail/$1';

// User
$route['logout'] = 'users/logout';
$route['login'] = 'users/login';
$route['verify'] = 'users/verify';
$route['edit-profile'] = 'users/editProfile';
$route['identity-inquiry'] = 'users/identityInquiry';

$route['auth-call'] = 'auth_call/index';
$route['auth-call/verify'] = 'auth_call/verify';
$route['auth-call/result'] = 'auth_call/result';

$route['transactions/(\d.*)'] = 'transactions/index/$1';
$route['cards/(\d.*)'] = 'cards/index/$1';
$route['buy/(\d.*)'] = 'cards/index/0/$1';

$route['product/(:any)'] = 'home/index/product/$1';
$route['category/(:any)'] = 'home/index/category/$1';

$route['tickets/(\d.*)'] = 'tickets/index/$1';

$route['charge'] = 'pay/charge';

$route['pardakht/redirect-payment'] = 'directpay';